/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.project.ProjectOptionRegistry;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ExportToTypeScript
@Option(id="finding.exclusion.approval", name="Approval workflow for tolerations and false positives", description="For information on the approval workflow see the [docs](documentation/reference/ui/findings/#exclusion-approval-workflow)\n", type=EOptionType.PROJECT, category=EOptionCategory.FINDING_EXCLUSION_WORKFLOW)
@IndexValueClass(containedInBackup=true)
public class FindingExclusionApprovalOption
implements IOption {
    private static final long serialVersionUID = 1L;
    @VisibleForTesting
    public static final String OPTION_ID = "finding.exclusion.approval";
    private static final String WORKFLOW_ENABLED_RED_FINDINGS_JSON_PROPERTY = "workflowEnabledRedFindings";
    private static final String WORKFLOW_ENABLED_YELLOW_FINDINGS_JSON_PROPERTY = "workflowEnabledYellowFindings";
    private static final String ALLOW_SELF_APPROVAL_JSON_PROPERTY = "allowSelfApproval";
    private static final String FINDING_CATEGORIES_JSON_PROPERTY = "findingCategories";
    @JsonProperty(value="workflowEnabledRedFindings")
    @OptionFieldDescription(name="Enable workflow for red findings")
    private final boolean workflowEnabledRedFindings;
    @JsonProperty(value="workflowEnabledYellowFindings")
    @OptionFieldDescription(name="Enable workflow for yellow findings")
    private final boolean workflowEnabledYellowFindings;
    @JsonProperty(value="allowSelfApproval")
    @OptionFieldDescription(name="Allow self-approval of pending finding exclusions", description="Whether it should be possible for someone with both the \"Mark\" and \"Approve\" permissions to approve their own pending exclusions.\n")
    private final boolean allowSelfApproval;
    @JsonProperty(value="findingCategories")
    @OptionFieldDescription(name="Limit workflow to following quality indicators", description="Comma-separated list of finding quality indicators (e.g., \"Structure\" or \"Security\"). Only findings in these quality indicators will require the finding exclusion approval workflow. Defaults to all quality indicators if empty.")
    private final String findingCategories;
    @JsonIgnore
    private transient UnmodifiableSet<String> parsedFindingCategories;

    public FindingExclusionApprovalOption() {
        this(false, false, false, "");
    }

    @JsonCreator
    private FindingExclusionApprovalOption(@JsonProperty(value="workflowEnabledRedFindings") boolean workflowEnabledRedFindings, @JsonProperty(value="workflowEnabledYellowFindings") boolean workflowEnabledYellowFindings, @JsonProperty(value="allowSelfApproval") boolean allowSelfApproval, @JsonProperty(value="findingCategories") String findingCategories) {
        this.workflowEnabledRedFindings = workflowEnabledRedFindings;
        this.workflowEnabledYellowFindings = workflowEnabledYellowFindings;
        this.allowSelfApproval = allowSelfApproval;
        this.findingCategories = Objects.requireNonNullElse(findingCategories, "");
    }

    @TestOnly
    public static FindingExclusionApprovalOption of(boolean workflowEnabledRedFindings, boolean workflowEnabledYellowFindings, boolean allowSelfApproval, Set<String> findingCategories) {
        return new FindingExclusionApprovalOption(workflowEnabledRedFindings, workflowEnabledYellowFindings, allowSelfApproval, String.join((CharSequence)",", findingCategories));
    }

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        return null;
    }

    public static FindingExclusionApprovalOption getInstance(ProjectOptionIndex projectOptionIndex) throws StorageException {
        FindingExclusionApprovalOption storedOption = (FindingExclusionApprovalOption)ProjectOptionRegistry.getInstance().getOption("<p>", OPTION_ID, null, FindingExclusionApprovalOption.class, (OptionIndexBase)projectOptionIndex);
        return Objects.requireNonNullElseGet(storedOption, () -> new FindingExclusionApprovalOption(false, false, false, ""));
    }

    public boolean isAllowSelfApproval() {
        return this.allowSelfApproval;
    }

    private UnmodifiableSet<String> getFindingCategories() {
        if (this.parsedFindingCategories != null) {
            return this.parsedFindingCategories;
        }
        this.parsedFindingCategories = UnmodifiableSet.of(Arrays.stream(this.findingCategories.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet()));
        return this.parsedFindingCategories;
    }

    public boolean shouldUseApprovalWorkflow(TrackedFinding finding) {
        ETrafficLightColor eTrafficLightColor = finding.getAssessment();
        int n = 0;
        boolean shouldUseApprovalWorkflow = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"RED", "YELLOW"}, (ETrafficLightColor)eTrafficLightColor, n)) {
            case 0 -> this.workflowEnabledRedFindings;
            case 1 -> this.workflowEnabledYellowFindings;
            default -> throw new UnsupportedOperationException("Unexpected assessment: " + String.valueOf(finding.getAssessment()));
        };
        return shouldUseApprovalWorkflow && (this.getFindingCategories().isEmpty() || this.getFindingCategories().contains((Object)finding.getCategoryName()));
    }
}

