/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.constraint;

import com.teamscale.index.code_clones.constraint.ICloneClassConstraint;
import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.CloneClass;
import java.util.List;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.region.Region;

public class MinimalOverlappingConstraint
implements ICloneClassConstraint {
    private final int minCloneLength;

    public MinimalOverlappingConstraint(int minCloneLength) {
        this.minCloneLength = minCloneLength;
    }

    @Override
    public boolean satisfied(CloneClass cloneClass) {
        ListMap cloneRegions = new ListMap();
        for (Clone clone : cloneClass.getClones()) {
            int endUnit;
            String uniformPath = clone.getUniformPath();
            int startUnit = clone.getStartUnitIndexInElement();
            Region cloneRegion = new Region(startUnit, endUnit = clone.getStartUnitIndexInElement() + clone.getLengthInUnits() - 1);
            if (this.tooLongOverlap(cloneRegion, (List)cloneRegions.getCollection((Object)uniformPath))) {
                return false;
            }
            cloneRegions.add((Object)uniformPath, (Object)cloneRegion);
        }
        return true;
    }

    private boolean tooLongOverlap(Region cloneRegion, List<Region> regionsInSameFile) {
        if (regionsInSameFile == null) {
            return false;
        }
        for (Region region : regionsInSameFile) {
            int overlapLength = MinimalOverlappingConstraint.getOverlapLength(cloneRegion, region);
            int nonOverLapLength = cloneRegion.getLength() - overlapLength;
            if (overlapLength == 0 || overlapLength < this.minCloneLength && nonOverLapLength >= this.minCloneLength) continue;
            return true;
        }
        return false;
    }

    private static int getOverlapLength(Region r1, Region r2) {
        int start = Math.max(r1.getStart(), r2.getStart());
        int end = Math.min(r1.getEnd(), r2.getEnd());
        if (end >= start) {
            return end - start + 1;
        }
        return 0;
    }
}

