/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.normalization;

import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.EntitySelectionExpressionParser;
import java.util.List;
import java.util.function.Predicate;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.region.RegionSet;

public class SimpleGetterSequenceDetector {
    private static final int MINIMAL_LENGTH = 5;
    private static final Predicate<ShallowEntity> SIMPLE_GETTER_SETTER_PREDICATE;
    private static final Predicate<ShallowEntity> SKIP_PREDICATE;

    public static RegionSet findRegions(List<ShallowEntity> parseTree) {
        RegionSet result = new RegionSet();
        SimpleGetterSequenceDetector.findRegions(parseTree, result);
        return result;
    }

    private static void findRegions(List<ShallowEntity> entities, RegionSet result) {
        if (entities.size() >= 5) {
            SimpleGetterSequenceDetector.scanForAdjacentSelectedEntities(entities, result);
        }
        for (ShallowEntity entity : entities) {
            if (!entity.hasChildren()) continue;
            SimpleGetterSequenceDetector.findRegions((List<ShallowEntity>)entity.getChildren(), result);
        }
    }

    private static void scanForAdjacentSelectedEntities(List<ShallowEntity> entities, RegionSet result) {
        for (int currentStart = 0; currentStart < entities.size(); ++currentStart) {
            ShallowEntity currentEntity = entities.get(currentStart);
            if (!SIMPLE_GETTER_SETTER_PREDICATE.test(currentEntity) || SKIP_PREDICATE.test(currentEntity)) continue;
            int count = 1;
            int endIndex = entities.size() - 1;
            for (int i = currentStart + 1; i < entities.size(); ++i) {
                if (SKIP_PREDICATE.test(entities.get(i))) continue;
                if (!SIMPLE_GETTER_SETTER_PREDICATE.test(entities.get(i))) break;
                ++count;
                endIndex = i;
            }
            if (count < 5) continue;
            result.add(new Region(currentEntity.getStartOffset(), entities.get(endIndex).getEndOffset()));
        }
    }

    static {
        SKIP_PREDICATE = entity -> entity.getType() == EShallowEntityType.META;
        try {
            SIMPLE_GETTER_SETTER_PREDICATE = EntitySelectionExpressionParser.parse((String)"simpleGetter | simpleSetter");
        }
        catch (ShallowParserException e) {
            throw new AssertionError("Expected to parse correctly!", e);
        }
    }
}

