/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.suffixtree;

import java.util.Arrays;

class SuffixTreeHashTable {
    private static final int[] allowedSizes = new int[]{53, 97, 193, 389, 769, 1543, 3079, 6151, 12289, 24593, 49157, 98317, 196613, 393241, 786433, 1572869, 0x30000B, 0x60000D, 0xC00005, 25165843, 0x3000005, 100663319, 201326611, 402653189, 805306457, 0x60000005};
    private final int tableSize;
    private final int[] keyNodes;
    private final Object[] keyChars;
    private final int[] resultNodes;
    private int _numStoredNodes = 0;
    private int _numFind = 0;
    private int _numColl = 0;

    public SuffixTreeHashTable(int numNodes) {
        int minSize = (int)Math.ceil(1.5 * (double)numNodes);
        int sizeIndex = 0;
        while (allowedSizes[sizeIndex] < minSize) {
            ++sizeIndex;
        }
        this.tableSize = allowedSizes[sizeIndex];
        this.keyNodes = new int[this.tableSize];
        this.keyChars = new Object[this.tableSize];
        this.resultNodes = new int[this.tableSize];
    }

    private int hashFind(int keyNode, Object keyChar) {
        ++this._numFind;
        int hash = keyChar.hashCode();
        int pos = this.posMod(SuffixTreeHashTable.primaryHash(keyNode, hash));
        int secondary = this.secondaryHash(keyNode, hash);
        while (!(this.keyChars[pos] == null || this.keyNodes[pos] == keyNode && keyChar.equals(this.keyChars[pos]))) {
            ++this._numColl;
            pos = (pos + secondary) % this.tableSize;
        }
        return pos;
    }

    public int get(int keyNode, Object keyChar) {
        int pos = this.hashFind(keyNode, keyChar);
        if (this.keyChars[pos] == null) {
            return -1;
        }
        return this.resultNodes[pos];
    }

    public void put(int keyNode, Object keyChar, int resultNode) {
        int pos = this.hashFind(keyNode, keyChar);
        if (this.keyChars[pos] == null) {
            ++this._numStoredNodes;
            this.keyChars[pos] = keyChar;
            this.keyNodes[pos] = keyNode;
        }
        this.resultNodes[pos] = resultNode;
    }

    private static int primaryHash(int keyNode, int keyCharHash) {
        return keyCharHash ^ 13 * keyNode;
    }

    private int secondaryHash(int keyNode, int keyCharHash) {
        int result = this.posMod(keyCharHash ^ 1025 * keyNode);
        if (result == 0) {
            return 2;
        }
        return result;
    }

    private int posMod(int x) {
        if ((x %= this.tableSize) < 0) {
            x += this.tableSize;
        }
        return x;
    }

    public void extractChildLists(int[] nodeFirstIndex, int[] nodeNextIndex, int[] nodeChild) {
        Arrays.fill(nodeFirstIndex, -1);
        int free = 0;
        for (int i = 0; i < this.tableSize; ++i) {
            if (this.keyChars[i] == null) continue;
            nodeChild[free] = this.resultNodes[i];
            nodeNextIndex[free] = nodeFirstIndex[this.keyNodes[i]];
            nodeFirstIndex[this.keyNodes[i]] = free++;
        }
    }

    public void _printDebugInfo() {
        System.err.println("STHashMap info: ");
        System.err.println("  Table size: " + this.tableSize);
        System.err.println("  Contained entries: " + this._numStoredNodes);
        System.err.println("  Fill factor: " + (double)this._numStoredNodes / (double)this.tableSize);
        System.err.println("  Number of finds: " + this._numFind);
        System.err.println("  Number of collisions: " + this._numColl);
    }
}

