/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.index.findings.kubescore.KubeScoreFindingsSynchronizer;
import com.teamscale.index.findings.kubescore.KubernetesKubeScoreChecksRunner;
import com.teamscale.index.findings.kubescore.KubernetesUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;

public class KubeScoreConfiguration
extends ToolConfigurationBase {
    public static final String KUBE_SCORE_FINDING_CATEGORY = "kube-score";
    private static final String KUBESCORE_DESCRIPTIONS_PATH = "kubescore";
    private static final String KUBESCORE_MAPPINGS_TSV = "kubescore/check-mappings.tsv";
    private static final String KUBESCORE_OPTIONS_TSV = "kubescore/check-options.tsv";
    private static final String DISABLE_CPU_LIMIT_OPTION_KEY = "kube-score.container-resources#kube-score.container-resources.disable-cpu-limit-check";
    @ConfigExposed(name="Helm values folder", description="The folder within a Helm chart that contains additional value files, which should be used for templating.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    public String helmValueFolder = "teamscale";
    @ConfigExposed(name="Helm value files regex", description="The regular expression that matches all value files, which should be used for templating.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    public String helmValueFilesRegex = ".*\\.yaml";

    public KubeScoreConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.KUBE_SCORE, KUBE_SCORE_FINDING_CATEGORY, KUBESCORE_DESCRIPTIONS_PATH, KUBESCORE_MAPPINGS_TSV, KUBESCORE_OPTIONS_TSV, "");
        this.autoExpose();
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        TriggerBuilder triggerBuilder = new TriggerBuilder(KubeScoreFindingsSynchronizer.class, ETriggerConcurrency.PARALLEL);
        triggerBuilder.setCost(ETriggerCost.EXPENSIVE);
        if (!StringUtils.isEmpty((String)this.helmValueFolder)) {
            triggerBuilder.setTriggerParameter("helm-value-folder", this.helmValueFolder);
        }
        if (!StringUtils.isEmpty((String)this.helmValueFilesRegex)) {
            triggerBuilder.setTriggerParameter("helm-value-files-regex", this.helmValueFilesRegex);
        }
        Boolean disableCpuLimit = (Boolean)((Map)this.valueByOptionsId.getValue(CodeScopeAware.DEFAULT_CODE_SCOPE)).get(DISABLE_CPU_LIMIT_OPTION_KEY);
        triggerBuilder.setTriggerParameter("disable-cpu-limit-check", disableCpuLimit.booleanValue());
        proxy.createTrigger(triggerBuilder);
        super.configureProjectInternal(proxy);
    }

    public void validateTools() throws ProjectConfigurationException {
        KubeScoreConfiguration.checkProgramAvailability(KubernetesKubeScoreChecksRunner.loadConfiguredKubescoreExe(), "kube-score version:");
        KubeScoreConfiguration.checkProgramAvailability(KubernetesUtils.loadConfiguredHelmExe(), "version.BuildInfo{Version:");
        KubeScoreConfiguration.checkProgramAvailability(KubernetesUtils.loadConfiguredKustomizeExe(), "v5.");
    }

    private static void checkProgramAvailability(String executablePath, String expectedVersionString) throws ProjectConfigurationException {
        try {
            CharSequence[] pathAndArgument = new String[]{executablePath, "version"};
            ProcessUtils.ExecutionResult result = ProcessUtils.execute((String[])pathAndArgument);
            Predicate<ProcessUtils.ExecutionResult> availabilityPredicate = executionResult -> executionResult.getReturnCode() == 0 && executionResult.getStdout().contains(expectedVersionString);
            if (!availabilityPredicate.test(result)) {
                throw new ProjectConfigurationException("Output of command '" + String.join((CharSequence)" ", pathAndArgument) + "' did not contain expected string '" + expectedVersionString + "' but only '" + result.getStdout() + "'");
            }
        }
        catch (IOException e) {
            throw new ProjectConfigurationException("Could not execute " + executablePath + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (!tools.contains(EAnalysisTool.KUBE_SCORE)) {
            return;
        }
        super.registerQualityIndicators(template, languages, tools);
        template.registerGlobalOption(this.getOptionForField("helmValueFolder"));
        template.registerGlobalOption(this.getOptionForField("helmValueFilesRegex"));
    }
}

