/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.index.configuration.tools.Rule;
import com.teamscale.index.configuration.tools.message.RuleBasedMessageManagerBase;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.EnumSet;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;

public abstract class RuleBasedToolConfigurationBase
extends ToolConfigurationBase {
    private final RuleBasedMessageManagerBase messageManager;

    protected RuleBasedToolConfigurationBase(RuleBasedMessageManagerBase messageManager, EAnalysisTool tool, String analysisGroupSuffix) {
        super(tool, messageManager.getFindingCategoryName(), analysisGroupSuffix);
        this.messageManager = messageManager;
    }

    private void registerFindings(CodeScopeName codeScope) {
        for (Rule rule : this.messageManager.getRules()) {
            FindingDescriptor finding = this.createFindingDescriptorFor(rule);
            String group = this.getGroup(this.messageManager.getAnalysisGroupNameFor(rule));
            this.registerFinding(finding, group, this.messageManager.getFindingsGroupNameFor(rule), codeScope);
        }
    }

    private FindingDescriptor createFindingDescriptorFor(Rule rule) {
        return new FindingDescriptor(RuleBasedMessageManagerBase.getFindingsDescriptorNameFor(rule), RuleBasedMessageManagerBase.getFindingsDescriptorNameForAsMarkdown(rule), this.tool, this.getSupportedLanguage(rule), this.messageManager.getFindingEnablementFor(rule), rule.description);
    }

    protected abstract EnumSet<ELanguage> getSupportedLanguage(Rule var1);

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.registerFindings(template.getCodeScope());
        super.registerQualityIndicators(template, languages, tools);
    }
}

