/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow;

import com.teamscale.index.dataflow.AssignmentTokenMarker;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ArithmeticExpressionTokenUtils {
    private static IToken replaceOperatorAssignment(IToken operator) {
        ETokenType type;
        String text;
        switch (operator.getType()) {
            case MINUSEQ: {
                text = "-";
                type = ETokenType.MINUS;
                break;
            }
            case PLUSEQ: {
                text = "+";
                type = ETokenType.PLUS;
                break;
            }
            case DIVEQ: {
                text = "/";
                type = ETokenType.DIV;
                break;
            }
            case MULTEQ: {
                text = "*";
                type = ETokenType.MULT;
                break;
            }
            case MODEQ: {
                text = "%";
                type = ETokenType.MOD;
                break;
            }
            case LSHIFTEQ: {
                text = "<<";
                type = ETokenType.LSHIFT;
                break;
            }
            case RSHIFTEQ: {
                text = ">>";
                type = ETokenType.RSHIFT;
                break;
            }
            case URSHIFTEQ: {
                text = ">>>";
                type = ETokenType.URSHIFT;
                break;
            }
            case ANDEQ: {
                text = "&";
                type = ETokenType.AND;
                break;
            }
            case OREQ: {
                text = "|";
                type = ETokenType.OR;
                break;
            }
            case XOREQ: {
                text = "^";
                type = ETokenType.XOR;
                break;
            }
            default: {
                return operator;
            }
        }
        return operator.newToken(type, operator.getOffset(), operator.getLineNumber(), text, operator.getOriginId());
    }

    public static List<IToken> replaceAssignments(List<IToken> tokens, Map<String, Integer> writesResolved) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        int openedParentheses = 0;
        for (int i = 0; i < tokens.size(); ++i) {
            IToken replacement;
            IToken token = tokens.get(i);
            if (token.getType().isOperator() && (token != (replacement = ArithmeticExpressionTokenUtils.replaceOperatorAssignment(token)) || token.getType() == ETokenType.EQ)) {
                openedParentheses = ArithmeticExpressionTokenUtils.replaceOperatorAssignment(token, replacement, tokens, i, result, writesResolved, openedParentheses);
                continue;
            }
            result.add(token);
        }
        IToken token = tokens.get(tokens.size() - 1);
        while (openedParentheses-- > 0) {
            result.add(token.newToken(ETokenType.RPAREN, token.getOffset(), token.getLineNumber(), ")", token.getOriginId()));
        }
        return result;
    }

    public static int precedence(IToken operator) {
        ETokenType type = operator.getType();
        return switch (type) {
            case ETokenType.EQ -> 0;
            case ETokenType.OR -> 1;
            case ETokenType.XOR -> 2;
            case ETokenType.AND -> 3;
            case ETokenType.LSHIFT, ETokenType.RSHIFT, ETokenType.URSHIFT -> 4;
            case ETokenType.PLUS, ETokenType.MINUS -> 5;
            case ETokenType.MULT, ETokenType.DIV, ETokenType.MOD -> 6;
            case ETokenType.NOT, ETokenType.COMP -> 7;
            default -> -1;
        };
    }

    private static int replaceOperatorAssignment(IToken token, IToken replacement, List<IToken> tokens, int index, List<IToken> result, Map<String, Integer> writesResolved, int openedParentheses) {
        IToken variable = tokens.get(index - 1);
        if (!variable.getType().isIdentifier()) {
            return 0;
        }
        String variableName = variable.getText();
        writesResolved.merge(variableName, 1, Integer::sum);
        if (token.getType() == ETokenType.EQ) {
            result.remove(result.size() - 1);
            result.add(token.newToken(token.getType(), token.getOffset(), token.getLineNumber(), variableName, token.getOriginId()));
            return openedParentheses;
        }
        result.add((IToken)new AssignmentTokenMarker(variableName, replacement));
        result.add(token.newToken(ETokenType.LPAREN, token.getOffset(), token.getLineNumber(), "(", token.getOriginId()));
        return ++openedParentheses;
    }

    public static List<IToken> generateShiftOperators(List<IToken> tokens) {
        ArrayList<IToken> newTokens = new ArrayList<IToken>();
        for (int index = 0; index < tokens.size() - 1; ++index) {
            IToken token = tokens.get(index);
            IToken nextToken = tokens.get(index + 1);
            if (token.getType() == ETokenType.LT && nextToken.getType() == ETokenType.LT) {
                newTokens.add(token.newToken(ETokenType.LSHIFT, token.getOffset(), token.getLineNumber(), "<<", token.getOriginId()));
                ++index;
                continue;
            }
            if (token.getType() == ETokenType.GT && nextToken.getType() == ETokenType.GT) {
                if (index + 2 < tokens.size() && tokens.get(index + 2).getType() == ETokenType.GT) {
                    newTokens.add(token.newToken(ETokenType.URSHIFT, token.getOffset(), token.getLineNumber(), ">>>", token.getOriginId()));
                    index += 2;
                    continue;
                }
                newTokens.add(token.newToken(ETokenType.RSHIFT, token.getOffset(), token.getLineNumber(), ">>", token.getOriginId()));
                ++index;
                continue;
            }
            newTokens.add(token);
        }
        newTokens.add(tokens.get(tokens.size() - 1));
        return newTokens;
    }

    public static int evaluate(ETokenType operator, int a, int b) {
        return switch (operator) {
            case ETokenType.PLUS -> b + a;
            case ETokenType.MINUS -> b - a;
            case ETokenType.MULT -> b * a;
            case ETokenType.DIV -> b / a;
            case ETokenType.MOD -> b % a;
            case ETokenType.LSHIFT -> b << a;
            case ETokenType.RSHIFT -> b >> a;
            case ETokenType.URSHIFT -> b >>> a;
            case ETokenType.AND -> b & a;
            case ETokenType.OR -> b | a;
            case ETokenType.XOR -> b ^ a;
            default -> throw new IllegalArgumentException("Unsupported operator encountered");
        };
    }

    public static List<List<IToken>> getAllRightSideOperands(List<IToken> tokens, ITokenMatcher operatorTypes) {
        List operations = TokenStreamUtils.findAll(tokens, (ITokenMatcher)operatorTypes);
        ArrayList<List<IToken>> operand = new ArrayList<List<IToken>>();
        Iterator iterator = operations.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            operand.add(ArithmeticExpressionTokenUtils.getRightSideOperand(index, tokens));
        }
        return operand;
    }

    public static List<IToken> getRightSideOperand(int operator, List<IToken> tokens) {
        IToken token;
        ETokenType tokenType;
        IToken operatorToken = tokens.get(operator);
        ArrayList<IToken> rightSide = new ArrayList<IToken>();
        int openParentheses = 0;
        for (int i = operator + 1; !(i >= tokens.size() || (tokenType = (token = tokens.get(i)).getType()) == ETokenType.COMMA || openParentheses == 0 && tokenType.isOperator() && ArithmeticExpressionTokenUtils.precedence(token) <= ArithmeticExpressionTokenUtils.precedence(operatorToken)); ++i) {
            if (tokenType == ETokenType.LPAREN) {
                ++openParentheses;
            } else if (tokenType == ETokenType.RPAREN && --openParentheses < 0) break;
            rightSide.add(token);
        }
        return rightSide;
    }

    public static boolean allParenthesesAreBalanced(List<IToken> tokens) {
        int parenthesesCounter = 0;
        for (IToken token : tokens) {
            if (parenthesesCounter < 0) {
                return false;
            }
            if (token.getType() == ETokenType.LPAREN) {
                ++parenthesesCounter;
                continue;
            }
            if (token.getType() != ETokenType.RPAREN) continue;
            --parenthesesCounter;
        }
        return parenthesesCounter == 0;
    }

    public static int evaluateIntegerNegation(int a) {
        if (a == 0) {
            return 1;
        }
        return 0;
    }

    public static List<IToken> filterTokens(List<IToken> tokens) {
        return ArithmeticExpressionTokenUtils.removeEmptyParentheses(tokens.stream().filter(e -> {
            ETokenType tokenType = e.getType();
            return tokenType.isOperator() || tokenType.isDelimiter() || tokenType.isIdentifier() || tokenType.isLiteral();
        }).collect(Collectors.toList()));
    }

    private static List<IToken> removeEmptyParentheses(List<IToken> tokens) {
        ArrayList<IToken> reducedTokens = new ArrayList<IToken>();
        boolean skip = false;
        for (int i = 0; i < tokens.size(); ++i) {
            if (skip) {
                skip = false;
                continue;
            }
            IToken token = tokens.get(i);
            if (token.getType() == ETokenType.LPAREN && tokens.get(i + 1).getType() == ETokenType.RPAREN) {
                skip = true;
                continue;
            }
            reducedTokens.add(token);
        }
        return reducedTokens;
    }

    public static Set<Integer> getUnaryOperatorLocations(List<IToken> tokens, ETokenType operator) {
        Predicate<Integer> isUnary = i -> i <= 0 || !((IToken)tokens.get(i - 1)).getType().isLiteral() && ((IToken)tokens.get(i - 1)).getType() != ETokenType.RPAREN && ((IToken)tokens.get(i - 1)).getType() != ETokenType.PLUSPLUS && ((IToken)tokens.get(i - 1)).getType() != ETokenType.MINUSMINUS;
        HashSet unaryOperatorIndices = new HashSet(TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{operator}));
        return unaryOperatorIndices.stream().filter(isUnary).collect(Collectors.toSet());
    }

    private ArithmeticExpressionTokenUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

