/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.teamscale.index.dataflow.IDataFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class DataFlowGraphIncludingLambdas
implements IDataFlowGraph {
    private final ControlFlowGraph cfg;
    private ImmutableListMultimap<ControlFlowNode, ControlFlowNode> crossLevelSuccessors;
    private ImmutableListMultimap<ControlFlowNode, ControlFlowNode> crossLevelPredecessors;

    public DataFlowGraphIncludingLambdas(ControlFlowGraph cfg) {
        this.cfg = cfg;
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        DataFlowGraphIncludingLambdas.collectCrossLevelDataflowPredecessors((ImmutableListMultimap.Builder<ControlFlowNode, ControlFlowNode>)builder, cfg.listDepthFirst(), cfg.getExitNode());
        this.crossLevelSuccessors = builder.build();
        this.crossLevelPredecessors = this.crossLevelSuccessors.inverse();
    }

    private static void collectCrossLevelDataflowPredecessors(ImmutableListMultimap.Builder<ControlFlowNode, ControlFlowNode> builder, List<ControlFlowNode> graphNodes, ControlFlowNode topLevelExit) {
        ArrayDeque<ControlFlowNode> nodesToProcess = new ArrayDeque<ControlFlowNode>(graphNodes);
        HashSet<ControlFlowNode> seenNodes = new HashSet<ControlFlowNode>();
        while (!nodesToProcess.isEmpty()) {
            ControlFlowNode node = (ControlFlowNode)nodesToProcess.pop();
            if (!seenNodes.add(node)) continue;
            for (ControlFlowGraph lambdaCfg : node.getLambdas()) {
                builder.put((Object)lambdaCfg.getExitNode(), (Object)topLevelExit);
                builder.put((Object)node, (Object)lambdaCfg.getRoot());
                nodesToProcess.addAll(lambdaCfg.listDepthFirst());
            }
        }
    }

    @Override
    public ControlFlowNode getEntry() {
        return this.cfg.getRoot();
    }

    @Override
    public ControlFlowNode getExit() {
        return this.cfg.getExitNode();
    }

    @Override
    public UnmodifiableList<ControlFlowNode> getSuccessors(ControlFlowNode node) {
        return DataFlowGraphIncludingLambdas.getAdjacentNodes(node, ControlFlowNode::getSuccessors, this.crossLevelSuccessors);
    }

    @Override
    public UnmodifiableList<ControlFlowNode> getPredecessors(ControlFlowNode node) {
        return DataFlowGraphIncludingLambdas.getAdjacentNodes(node, ControlFlowNode::getPredecessors, this.crossLevelPredecessors);
    }

    private static UnmodifiableList<ControlFlowNode> getAdjacentNodes(ControlFlowNode node, Function<ControlFlowNode, List<ControlFlowNode>> adjaceny, ListMultimap<ControlFlowNode, ControlFlowNode> crossLevelAdjacency) {
        List<ControlFlowNode> adjacentNodes;
        List adjacentLambdaNodes = crossLevelAdjacency.get((Object)node);
        if (!adjacentLambdaNodes.isEmpty()) {
            adjacentNodes = new ArrayList<ControlFlowNode>((Collection)adjaceny.apply(node));
            adjacentNodes.addAll(adjacentLambdaNodes);
        } else {
            adjacentNodes = adjaceny.apply(node);
        }
        return CollectionUtils.asUnmodifiable(adjacentNodes);
    }
}

