/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow;

import com.google.common.collect.ImmutableMap;
import com.teamscale.index.dataflow.DataflowAnalysisBase;
import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.EDirection;
import com.teamscale.index.dataflow.ILattice;
import com.teamscale.index.dataflow.PathFeasibilityLattice;
import com.teamscale.index.dataflow.PathSensitiveAnalysisState;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;

public abstract class PathSensitiveDataflowAnalysisBase<ValueT>
extends DataflowAnalysisBase<Set<PathSensitiveAnalysisState<ValueT>>, PathSensitiveAnalysisState<ValueT>, DataflowAnalysisResult<String, ValueT>> {
    @Override
    protected Set<PathSensitiveAnalysisState<ValueT>> getDefaultState(ControlFlowNode node) {
        return new HashSet<PathSensitiveAnalysisState<ValueT>>();
    }

    @Override
    protected boolean addToOutState(PathSensitiveAnalysisState<ValueT> transformationResult, Set<PathSensitiveAnalysisState<ValueT>> outputState, ControlFlowNode node) {
        return this.isFeasible(transformationResult) && outputState.add(transformationResult);
    }

    @Override
    protected PathSensitiveAnalysisState<ValueT> getStartingInput(ControlFlowGraph cfg) {
        HashMap<String, ValueT> valueState = new HashMap<String, ValueT>();
        HashMap<String, PathFeasibilityLattice.EFeasibility> feasibilityState = new HashMap<String, PathFeasibilityLattice.EFeasibility>();
        for (String variable : cfg.getDefinedVariables()) {
            valueState.put(variable, this.getLattice().getBottom());
            feasibilityState.put(variable, PathFeasibilityLattice.EFeasibility.UNKNOWN);
        }
        return new PathSensitiveAnalysisState(ImmutableMap.copyOf(valueState), (ImmutableMap<String, PathFeasibilityLattice.EFeasibility>)ImmutableMap.copyOf(feasibilityState));
    }

    @Override
    protected boolean isFeasible(PathSensitiveAnalysisState<ValueT> transformationResult) {
        return !transformationResult.feasibilityState.values().contains((Object)PathFeasibilityLattice.EFeasibility.INFEASIBLE_VALUE);
    }

    @Override
    protected Set<PathSensitiveAnalysisState<ValueT>> join(List<Set<PathSensitiveAnalysisState<ValueT>>> states, ControlFlowNode node) {
        return CollectionUtils.unionSetAll(states);
    }

    @Override
    protected PathSensitiveAnalysisState<ValueT> transform(ControlFlowNode block, PathSensitiveAnalysisState<ValueT> input) throws ConQATException {
        ImmutableMap<String, PathFeasibilityLattice.EFeasibility> previousState = input.feasibilityState;
        Map<String, PathFeasibilityLattice.EFeasibility> changedFeasibilityValues = PathSensitiveDataflowAnalysisBase.determineChangedFeasibilityValues(block, previousState);
        ImmutableMap<String, ValueT> values = this.transformValues(block, input);
        if (changedFeasibilityValues.isEmpty()) {
            return new PathSensitiveAnalysisState<ValueT>(values, previousState);
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builderWithExpectedSize((int)previousState.size());
        mapBuilder.putAll(previousState);
        mapBuilder.putAll(changedFeasibilityValues);
        return new PathSensitiveAnalysisState<ValueT>(values, (ImmutableMap<String, PathFeasibilityLattice.EFeasibility>)mapBuilder.buildKeepingLast());
    }

    protected abstract ImmutableMap<String, ValueT> transformValues(ControlFlowNode var1, PathSensitiveAnalysisState<ValueT> var2) throws ConQATException;

    private static Map<String, PathFeasibilityLattice.EFeasibility> determineChangedFeasibilityValues(ControlFlowNode block, Map<String, PathFeasibilityLattice.EFeasibility> previousState) {
        HashMap<String, PathFeasibilityLattice.EFeasibility> changedFeasibilityValues = new HashMap<String, PathFeasibilityLattice.EFeasibility>();
        for (VariableWrite assignment : block.getReadWriteInfo().getAllWrites()) {
            PathFeasibilityLattice.EFeasibility newFeasibility = PathSensitiveDataflowAnalysisBase.determineNewFeasibility(assignment, previousState, changedFeasibilityValues);
            PathFeasibilityLattice.EFeasibility oldFeasibility = PathSensitiveDataflowAnalysisBase.getFeasibility(previousState, assignment.getChangedVariable());
            if (block.isAssumeNode()) {
                newFeasibility = PathFeasibilityLattice.INSTANCE.leastUpperBound(newFeasibility, oldFeasibility);
            }
            if (newFeasibility == oldFeasibility) continue;
            changedFeasibilityValues.put(assignment.getChangedVariable(), newFeasibility);
        }
        return changedFeasibilityValues;
    }

    private static PathFeasibilityLattice.EFeasibility determineNewFeasibility(VariableWrite assignment, Map<String, PathFeasibilityLattice.EFeasibility> previousState, Map<String, PathFeasibilityLattice.EFeasibility> changedFeasibilityStates) {
        return switch (assignment.getType()) {
            default -> throw new MatchException(null, null);
            case VariableWrite.EVariableWriteType.NULL -> PathFeasibilityLattice.EFeasibility.NULL;
            case VariableWrite.EVariableWriteType.EMPTY, VariableWrite.EVariableWriteType.VALUE -> PathFeasibilityLattice.EFeasibility.NON_NULL;
            case VariableWrite.EVariableWriteType.OTHER -> PathFeasibilityLattice.EFeasibility.UNKNOWN;
            case VariableWrite.EVariableWriteType.VARIABLE -> changedFeasibilityStates.containsKey(assignment.getValueVariable()) ? changedFeasibilityStates.get(assignment.getValueVariable()) : PathSensitiveDataflowAnalysisBase.getFeasibility(previousState, assignment.getValueVariable());
        };
    }

    private static PathFeasibilityLattice.EFeasibility getFeasibility(Map<String, PathFeasibilityLattice.EFeasibility> state, String variable) {
        return state.getOrDefault(variable, PathFeasibilityLattice.EFeasibility.UNKNOWN);
    }

    @Override
    protected DataflowAnalysisResult<String, ValueT> getResult(ControlFlowGraph cfg, Map<ControlFlowNode, Set<PathSensitiveAnalysisState<ValueT>>> outStates) {
        Map<ControlFlowNode, Set<PathSensitiveAnalysisState<Object>>> states = outStates;
        if (this.getDirection() == EDirection.FORWARD) {
            states = this.computeInStates();
        }
        HashMap results = new HashMap();
        for (Map.Entry<ControlFlowNode, Set<PathSensitiveAnalysisState<Object>>> entry : states.entrySet()) {
            UnmodifiableMap<String, ValueT> mergedState = this.merge(entry.getValue(), cfg);
            results.put(entry.getKey(), mergedState);
        }
        return new DataflowAnalysisResult(cfg, results);
    }

    private UnmodifiableMap<String, ValueT> merge(Set<PathSensitiveAnalysisState<ValueT>> states, ControlFlowGraph cfg) {
        HashMap<String, ValueT> mergedState = new HashMap<String, ValueT>();
        for (String variable : cfg.getDefinedVariables()) {
            Object value = this.getLattice().getBottom();
            for (PathSensitiveAnalysisState<ValueT> state : states) {
                Object valueToMerge = state.getValueState().get((Object)variable);
                if (valueToMerge == null) continue;
                value = this.getLattice().leastUpperBound(value, valueToMerge);
            }
            mergedState.put(variable, value);
        }
        return CollectionUtils.asUnmodifiable(mergedState);
    }

    protected abstract ILattice<ValueT> getLattice();
}

