/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.dataflow.nullpointer.NullPointerFindingsCreationUtils;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class MallocAssignmentFilter
implements IFalsePositiveFilter {
    private final Set<String> safeAssignmentFunctions = CollectionUtils.asHashSet((Object[])new String[]{"malloc"});

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> fileEntities, TokenElementInfo element) throws ConQATException {
        HashSet<ControlFlowNode> visited = new HashSet<ControlFlowNode>();
        LinkedList<ControlFlowNode> workList = new LinkedList<ControlFlowNode>(statement.getPredecessors());
        while (!workList.isEmpty()) {
            ControlFlowNode node = (ControlFlowNode)workList.poll();
            if (visited.contains(node)) continue;
            visited.add(node);
            if (NullPointerFindingsCreationUtils.hasWriteForVariable(node, variable)) {
                if (!this.isVariableAssignedByMalloc(variable, node)) continue;
                return true;
            }
            workList.addAll(node.getPredecessors());
        }
        return false;
    }

    private boolean isVariableAssignedByMalloc(String variable, ControlFlowNode block) {
        List<IToken> nodeTokens = block.getTokens();
        for (Integer assignmentIndex : TokenStreamUtils.allStartingIndicesOfTypeSequence(nodeTokens, (int)0, (int)nodeTokens.size(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.EQ})) {
            List<IToken> assignmentValueTokens;
            if (!nodeTokens.get(assignmentIndex).getText().equals(variable) || nodeTokens.size() <= assignmentIndex + 2 || !NullPointerFindingsCreationUtils.isFunctionCallTo(assignmentValueTokens = nodeTokens.subList(assignmentIndex + 2, nodeTokens.size()), this.safeAssignmentFunctions)) continue;
            return true;
        }
        return false;
    }
}

