/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.nullpointer;

import com.teamscale.index.dataflow.controlflowgraph.Condition;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.nullpointer.NullPointerLattice;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.NestingAwareTokenIterator;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class NullPointerFindingsCreationUtils {
    static boolean isInterestingNullness(NullPointerLattice.ENullness nullness, String variable, ControlFlowNode statement, TwoDimHashMap<ControlFlowNode, String, NullPointerLattice.ENullness> nullnessFactsInOtherNodes) {
        if (nullness == NullPointerLattice.ENullness.NULL) {
            return true;
        }
        return nullness == NullPointerLattice.ENullness.MAYBE_NULL && NullPointerFindingsCreationUtils.isNullChecked(variable, statement, nullnessFactsInOtherNodes);
    }

    private static boolean isNullChecked(String variable, ControlFlowNode statement, TwoDimHashMap<ControlFlowNode, String, NullPointerLattice.ENullness> nullnessFactsInOtherNodes) {
        return NullPointerFindingsCreationUtils.isNullCheckedForward(variable, statement, nullnessFactsInOtherNodes) || NullPointerFindingsCreationUtils.isNullCheckedBackwards(variable, statement);
    }

    private static boolean isNullCheckedForward(String variable, ControlFlowNode statement, TwoDimHashMap<ControlFlowNode, String, NullPointerLattice.ENullness> nullnessFactsInOtherNodes) {
        HashSet<ControlFlowNode> seen = new HashSet<ControlFlowNode>();
        Stack<ControlFlowNode> workList = new Stack<ControlFlowNode>();
        workList.add(statement);
        while (!workList.isEmpty()) {
            ControlFlowNode node = (ControlFlowNode)workList.pop();
            if (seen.contains(node)) continue;
            seen.add(node);
            if (NullPointerFindingsCreationUtils.isNullCheckedIn(node, variable)) {
                return true;
            }
            if (NullPointerFindingsCreationUtils.hasWriteForVariable(node, variable) || node.getPredecessors().size() > 1 && !NullPointerFindingsCreationUtils.allDirectPredecessorsNullnessMatches(node, variable, nullnessFactsInOtherNodes)) continue;
            workList.addAll(node.getSuccessors());
        }
        return false;
    }

    private static boolean allDirectPredecessorsNullnessMatches(ControlFlowNode node, String variableName, TwoDimHashMap<ControlFlowNode, String, NullPointerLattice.ENullness> nullnessFactsInOtherNodes) {
        Set nullnessValues = node.getPredecessors().stream().map(predecessor -> (NullPointerLattice.ENullness)((Object)((Object)nullnessFactsInOtherNodes.getValue(predecessor, (Object)variableName)))).collect(Collectors.toSet());
        return nullnessValues.size() <= 1;
    }

    public static boolean hasWriteForVariable(ControlFlowNode node, String variable) {
        for (VariableWrite write : node.getReadWriteInfo().getAllWrites()) {
            if (!write.getChangedVariable().equals(variable)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullCheckedIn(ControlFlowNode node, String variable) {
        Condition condition = node.getCondition();
        return condition != null && condition.getNullCheckedVariables().contains(variable);
    }

    private static boolean isNullCheckedBackwards(String variable, ControlFlowNode statement) {
        HashSet<ControlFlowNode> seen = new HashSet<ControlFlowNode>();
        Stack<ControlFlowNode> workList = new Stack<ControlFlowNode>();
        workList.addAll(statement.getPredecessors());
        while (!workList.isEmpty()) {
            ControlFlowNode node = (ControlFlowNode)workList.pop();
            if (seen.contains(node)) continue;
            seen.add(node);
            if (NullPointerFindingsCreationUtils.hasWriteForVariable(node, variable)) {
                return false;
            }
            if (NullPointerFindingsCreationUtils.isNullCheckedIn(node, variable)) {
                return true;
            }
            workList.addAll(node.getPredecessors());
        }
        return false;
    }

    public static boolean isFunctionCallTo(List<IToken> tokens, Set<String> functionNames) {
        NestingAwareTokenIterator iterator = new NestingAwareTokenIterator(tokens, 0, Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN));
        while (iterator.hasNext()) {
            IToken token = iterator.next();
            if (!iterator.isTopLevel()) continue;
            if (token.getType() == ETokenType.IDENTIFIER && functionNames.contains(token.getText())) {
                return true;
            }
            if (!EnumSet.of(ETokenType.LBRACE, ETokenType.SEMICOLON).contains(token.getType())) continue;
            return false;
        }
        return false;
    }

    public static String createMessage(String dereferencedVariable) {
        return "The variable `" + dereferencedVariable + "` may contain a null value at this point and is dereferenced";
    }

    private NullPointerFindingsCreationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

