/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex;

import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodTaintGraphIndexBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodTaintGraphWithPaths;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

@Index(name="enriched-method-taint-graphs", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class EnrichedMethodTaintGraphIndex
extends MethodTaintGraphIndexBase<MethodTaintGraphWithPaths> {
    public static final String INDEX_NAME = "enriched-method-taint-graphs";

    public EnrichedMethodTaintGraphIndex(IStore store) {
        super(store);
    }

    public void updateMethodTaintGraphs(Map<String, MethodTaintGraphWithPaths> taintGraphsToUpdateByMethodId, Set<String> identifiersOfAffectedMethods) throws StorageException {
        Map<String, List<String>> affectedUniformPaths = identifiersOfAffectedMethods.stream().collect(Collectors.groupingBy(TaintAnalysisUtils::getUniformPathFromMethodIdentifier));
        Map<String, List<MethodTaintGraphWithPaths>> updatedByUniformPath = taintGraphsToUpdateByMethodId.values().stream().collect(Collectors.groupingBy(graph -> TaintAnalysisUtils.getUniformPathFromMethodIdentifier(graph.getMethodIdentifier())));
        ArrayList uniformPaths = new ArrayList(CollectionUtils.unionSet(affectedUniformPaths.keySet(), (Collection[])new Collection[]{updatedByUniformPath.keySet()}));
        List rawValues = this.store.getWithStrings(uniformPaths);
        PairList keysValuesToWrite = new PairList();
        ArrayList<String> keysToDelete = new ArrayList<String>();
        for (int i = 0; i < uniformPaths.size(); ++i) {
            String uniformPath = (String)uniformPaths.get(i);
            Map taintGraphsByMethodId = EnrichedMethodTaintGraphIndex.deserializeToMap((byte[])rawValues.get(i));
            CollectionUtils.removeAll(taintGraphsByMethodId.keySet(), affectedUniformPaths.getOrDefault(uniformPath, Collections.emptyList()));
            for (MethodTaintGraphWithPaths graph2 : updatedByUniformPath.getOrDefault(uniformPath, Collections.emptyList())) {
                taintGraphsByMethodId.put(graph2.getMethodIdentifier(), graph2);
            }
            if (taintGraphsByMethodId.isEmpty()) {
                keysToDelete.add(uniformPath);
                continue;
            }
            keysValuesToWrite.add((Object)uniformPath, (Object)this.sortAndSerialize(taintGraphsByMethodId.values()));
        }
        if (!keysToDelete.isEmpty()) {
            this.store.removeWithStrings(keysToDelete);
        }
        if (!keysValuesToWrite.isEmpty()) {
            this.store.putWithStrings(keysValuesToWrite);
        }
    }
}

