/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.info;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.IContentAdjustable;
import com.teamscale.index.external.result.ExternalAnalysisResult;
import com.teamscale.index.external.result.ExternalAnalysisResultFindings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.ILineAdjuster;
import org.conqat.engine.commons.findings.location.LocationAdjuster;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class ExternalAnalysisImportInfoFindings
extends ExternalAnalysisImportInfo<List<DetachedFinding>>
implements IContentAdjustable {
    private static final long serialVersionUID = 1L;
    private static final String FINDINGS_PROPERTY = "findings";
    private static final String CONTENT_PROPERTY = "content";
    private static final String DELETED_FINDINGS_PROPERTY = "deletedFindings";
    @JsonProperty(value="findings")
    private final List<DetachedFinding> findings;
    @JsonProperty(value="content")
    private final @Nullable String content;
    @JsonProperty(value="deletedFindings")
    private final @Nullable List<DetachedFinding> deletedFindings;

    public ExternalAnalysisImportInfoFindings(String uniformPath, List<DetachedFinding> findings) {
        this(uniformPath, findings, Collections.emptyList());
    }

    public ExternalAnalysisImportInfoFindings(String uniformPath, List<DetachedFinding> findings, List<DetachedFinding> deletedFindings) {
        this(uniformPath, findings, deletedFindings, null);
    }

    public ExternalAnalysisImportInfoFindings(String uniformPath, List<DetachedFinding> findings, String content) {
        this(uniformPath, findings, Collections.emptyList(), content);
    }

    @JsonCreator
    private ExternalAnalysisImportInfoFindings(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="findings") List<DetachedFinding> findings, @JsonProperty(value="deletedFindings") List<DetachedFinding> deletedFindings, @JsonProperty(value="content") @Nullable String content) {
        super(uniformPath);
        this.findings = new ArrayList<DetachedFinding>(findings);
        this.content = content;
        this.deletedFindings = new ArrayList<DetachedFinding>(deletedFindings);
    }

    public synchronized void adjustFindings(ILineAdjuster adjuster) {
        ArrayList<DetachedFinding> copiedFindings = new ArrayList<DetachedFinding>(this.findings);
        this.findings.clear();
        for (DetachedFinding finding : copiedFindings) {
            ElementLocation newLocation = adjuster.adjustLocation(finding.getLocation());
            if (newLocation == null) continue;
            finding.setLocation(newLocation);
            this.findings.add(finding);
        }
    }

    public void retainMatching(Predicate<? super DetachedFinding> keepPredicate) {
        ArrayList findingsToKeep = new ArrayList(CollectionUtils.filter(this.findings, keepPredicate));
        this.findings.clear();
        this.findings.addAll(findingsToKeep);
    }

    @Override
    public List<DetachedFinding> getData() {
        return CollectionUtils.asUnmodifiable(this.findings);
    }

    public void mergeFindings(ExternalAnalysisImportInfoFindings other) {
        this.findings.addAll(other.findings);
    }

    public ExternalAnalysisResultFindings createAnalysisResult() {
        throw new UnsupportedOperationException("Findings always need to be adjusted before creating an analysis result. Please call createAdjustedAnalysisResult instead.");
    }

    @Override
    public ExternalAnalysisResult<?> createAdjustedAnalysisResult(BasicTokenElementInfo content, String uniformPath, CodeScopeName codeScopeName, ExternalAnalysisImportInfo.IFindingAdjuster.IFactory findingsAdjusterFactory, ExternalAnalysisImportInfo.IDependencyAdjuster.Factory dependencyAdjusterFactory) throws ConQATException {
        String importedContent = this.content;
        if (StringUtils.isEmpty((String)importedContent)) {
            importedContent = content.getText();
        }
        LocationAdjuster locationAdjuster = new LocationAdjuster(importedContent, content.getText(), uniformPath);
        ExternalAnalysisImportInfo.IFindingAdjuster findingAdjuster = findingsAdjusterFactory.produce(importedContent, codeScopeName, locationAdjuster);
        return new ExternalAnalysisResultFindings(findingAdjuster.adjust(this.findings), findingAdjuster.adjust(Optional.ofNullable(this.deletedFindings).orElse(Collections.emptyList())));
    }

    public void addFinding(DetachedFinding finding) {
        this.findings.add(finding);
    }

    @TestOnly
    public Stream<DetachedFinding> getAllFindings() {
        return Stream.of(this.findings, this.deletedFindings).filter(Objects::nonNull).flatMap(Collection::stream);
    }
}

