/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.update;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@Index(name="external-results-partition-last-update", options={EStorageOption.BRANCHED})
public class ExternalResultsPartitionLastUpdateIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "external-results-partition-last-update";
    private final ValueIndex<PartitionUpdateEntry> delegate;

    public ExternalResultsPartitionLastUpdateIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public Map<String, CommitDescriptor> getPartitionToLastUpdateMap() throws StorageException {
        return this.delegate.getAllEntries().mapSecond(entry -> entry.latestUploadCommit).toMap();
    }

    public Map<String, CommitDescriptor> getPartitionToLastUpdateMap(List<String> partitions) throws StorageException {
        Map partitionToLastUpdateEntryMap = this.delegate.getValuesByKeys(partitions);
        return CollectionUtils.map((Map)partitionToLastUpdateEntryMap, key -> key, value -> value.latestUploadCommit);
    }

    public PairList<String, Long> getPartitionsUpdatedWithCommit(CommitDescriptor commit) throws StorageException {
        PairList partitionsUpdatedWithCommit = this.delegate.getAllEntries().filter((key, value) -> commit.equals((Object)value.latestUploadCommit));
        return partitionsUpdatedWithCommit.mapSecond(entry -> entry.latestIndexWriteTimestamp);
    }

    public void setPartitionsLastUpdated(PairList<String, CommitDescriptor> partitionsAndLastUpdatedCommit) throws StorageException {
        long writeTimestamp = Instant.now().toEpochMilli();
        PairList partitionAndLastUpdateEntryMap = partitionsAndLastUpdatedCommit.mapSecond(commit -> new PartitionUpdateEntry((CommitDescriptor)commit, writeTimestamp));
        this.delegate.setValues(partitionAndLastUpdateEntryMap);
    }

    public Optional<CommitDescriptor> getLastUpdatedCommit(String partition) throws StorageException {
        PartitionUpdateEntry result = (PartitionUpdateEntry)this.delegate.getValue(partition);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(result.latestUploadCommit());
    }

    public void setPartitionLastUpdated(String partition, CommitDescriptor commit) throws StorageException {
        this.delegate.setValue(partition, (Object)new PartitionUpdateEntry(commit, Instant.now().toEpochMilli()));
    }

    public List<@Nullable CommitDescriptor> getLastUpdatedCommits(List<String> partitions) throws StorageException {
        List result = this.delegate.getValues(partitions);
        return CollectionUtils.map((Collection)result, entry -> {
            if (entry == null) {
                return null;
            }
            return entry.latestUploadCommit;
        });
    }

    @IndexValueClass
    private record PartitionUpdateEntry(CommitDescriptor latestUploadCommit, long latestIndexWriteTimestamp) implements Serializable
    {
    }
}

