/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.kubescore;

import com.teamscale.index.findings.kubescore.KubeScoreReportReader;
import com.teamscale.index.findings.kubescore.KubernetesChecksRunner;
import com.teamscale.index.findings.kubescore.KubernetesManifestHandler;
import com.teamscale.index.findings.kubescore.KubernetesUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.io.ProcessUtils;

public class KubernetesKubeScoreChecksRunner
extends KubernetesChecksRunner {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String KUBE_SCORE_EXE_VM_PROPERTY_NAME = "com.teamscale.worker.kube-score-executable";
    private static final Pattern SOURCE_COMMENT_REGEX = Pattern.compile("# Source: .*\n");
    private final boolean disableCpuLimitCheck;

    public KubernetesKubeScoreChecksRunner(boolean disableCpuLimitCheck) {
        this.disableCpuLimitCheck = disableCpuLimitCheck;
    }

    @Override
    protected List<IndexFinding> run(String fileContent, String uniformPath) {
        KubernetesManifestHandler kubernetesManifestHandler = new KubernetesManifestHandler(fileContent, uniformPath);
        try {
            String stdout;
            ProcessUtils.ExecutionResult result = KubernetesUtils.executeKubernetesProcess(this.getKubeScoreCommandStaticManifest(), KubernetesKubeScoreChecksRunner.removeOriginReferences(fileContent));
            String stderr = result.getStderr();
            if (!stderr.isEmpty()) {
                LOGGER.warn("kube-score execution error for {}: {}", (Object)uniformPath, (Object)stderr);
            }
            if (!(stdout = result.getStdout()).isEmpty()) {
                return KubeScoreReportReader.parseReport(stdout, uniformPath, kubernetesManifestHandler);
            }
        }
        catch (IOException | ConQATException e) {
            LOGGER.error("Failed to execute kube-score for {}", (Object)uniformPath, (Object)e);
        }
        return new ArrayList<IndexFinding>();
    }

    private static String removeOriginReferences(String fileContent) {
        return SOURCE_COMMENT_REGEX.matcher(fileContent).replaceAll("\n");
    }

    private List<String> getKubeScoreCommandStaticManifest() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(KubernetesKubeScoreChecksRunner.loadConfiguredKubescoreExe());
        command.add("score");
        if (this.disableCpuLimitCheck) {
            command.add("--ignore-container-cpu-limit");
        }
        command.add("-o");
        command.add("json");
        command.add("-");
        return command;
    }

    public static String loadConfiguredKubescoreExe() {
        return System.getProperty(KUBE_SCORE_EXE_VM_PROPERTY_NAME, "kube-score");
    }
}

