/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.rtc;

import com.teamscale.commons.service.client.ServiceCallException;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.function.RunnableWithException;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public class RtcLoginInterceptor
implements Interceptor {
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    static final String AUTH_REQUIRED_HEADER_NAME = "X-com-ibm-team-repository-web-auth-msg";
    @VisibleForTesting
    static final String AUTH_REQUIRED = "authrequired";
    private final RunnableWithException<ServiceCallException> sendLoginRequests;

    public RtcLoginInterceptor(RunnableWithException<ServiceCallException> sendLoginRequests) {
        this.sendLoginRequests = sendLoginRequests;
    }

    public @NonNull Response intercept(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        HttpUrl requestUrl = chain.request().url();
        if (this.isPreLoginRequest(requestUrl)) {
            return response;
        }
        if (this.isLoginRequest(requestUrl)) {
            return this.interceptLoginRequest(response);
        }
        if (RtcLoginInterceptor.isSuccessfulResponse(response)) {
            return response;
        }
        if (!RtcLoginInterceptor.isLoginRequired(response)) {
            String message = "Request to  " + String.valueOf(requestUrl) + " failed: " + response.code();
            if (response.body() != null) {
                message = message + "\nResponse content: " + response.body().string();
            }
            response.close();
            throw new IOException(message);
        }
        LOGGER.info("Request to {} failed because we are not logged in. Logging in.", (Object)requestUrl);
        response.close();
        try {
            this.sendLoginRequests.run();
        }
        catch (ServiceCallException e) {
            throw new IOException(e);
        }
        return chain.proceed(chain.request().newBuilder().build());
    }

    private boolean isPreLoginRequest(HttpUrl requestUrl) {
        return requestUrl.encodedPath().contains("authenticated/identity");
    }

    private boolean isLoginRequest(HttpUrl requestUrl) {
        return requestUrl.encodedPath().contains("authenticated/j_security_check");
    }

    private Response interceptLoginRequest(Response response) throws IOException {
        if (response.code() == 200 || response.code() == 302) {
            return response;
        }
        throw new IOException("Login failed: " + response.message());
    }

    private static boolean isSuccessfulResponse(Response response) {
        return response.code() == 200 && !RtcLoginInterceptor.hasAuthRequiredHeader(response);
    }

    private static boolean isLoginRequired(Response response) {
        if (response.code() == 302 || response.code() == 401) {
            return true;
        }
        return RtcLoginInterceptor.hasAuthRequiredHeader(response);
    }

    private static boolean hasAuthRequiredHeader(Response response) {
        String authRequiredHeader = response.header(AUTH_REQUIRED_HEADER_NAME);
        return authRequiredHeader != null && authRequiredHeader.equals(AUTH_REQUIRED);
    }
}

