/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.tfs;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.tfs.wiql.EWiqlWhereClauseCombinator;
import com.teamscale.core.tfs.wiql.IWiqlWhereOperator;
import com.teamscale.core.tfs.wiql.WiqlWhereClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.jetbrains.annotations.VisibleForTesting;

public class TfsWorkItemFilterParameters {
    private static final String AREA_PREFIX = "area.";
    private static final String ITERATION_PREFIX = "iteration.";
    private static final String TAG_PREFIX = "tag.";
    @StepParameterObject(namePrefix="area.")
    private final IncludeExcludeRecursiveFilterParameters areaFilter;
    @StepParameterObject(namePrefix="iteration.")
    private final IncludeExcludeRecursiveFilterParameters iterationFilter;
    @StepParameterObject(namePrefix="tag.")
    private final IncludeExcludeFilterParameters tagFilter;

    public TfsWorkItemFilterParameters() {
        this.areaFilter = new IncludeExcludeRecursiveFilterParameters();
        this.iterationFilter = new IncludeExcludeRecursiveFilterParameters();
        this.tagFilter = new IncludeExcludeFilterParameters();
    }

    public TfsWorkItemFilterParameters(IncludeExcludeRecursiveFilterParameters areaFilter, IncludeExcludeRecursiveFilterParameters iterationFilter, IncludeExcludeFilterParameters tagFilter) {
        this.areaFilter = areaFilter;
        this.iterationFilter = iterationFilter;
        this.tagFilter = tagFilter;
    }

    public void setTriggerParameters(TriggerBuilder builder) {
        this.areaFilter.setTriggerParameters(builder, AREA_PREFIX);
        this.iterationFilter.setTriggerParameters(builder, ITERATION_PREFIX);
        this.tagFilter.setTriggerParameters(builder, TAG_PREFIX);
    }

    @VisibleForTesting
    public void setTriggerParameters(Map<String, Object> parameters) {
        this.areaFilter.setTriggerParameters(parameters, AREA_PREFIX);
        this.iterationFilter.setTriggerParameters(parameters, ITERATION_PREFIX);
        this.tagFilter.setTriggerParameters(parameters, TAG_PREFIX);
    }

    public WiqlWhereClause buildWiqlClause() {
        ArrayList<WiqlWhereClause> clauses = new ArrayList<WiqlWhereClause>();
        clauses.add(TfsWorkItemFilterParameters.buildIncludeExcludeClause("System.AreaPath", this.areaFilter));
        clauses.add(TfsWorkItemFilterParameters.buildIncludeExcludeClause("System.IterationPath", this.iterationFilter));
        clauses.add(TfsWorkItemFilterParameters.buildContainsClauses("System.Tags", this.tagFilter));
        return WiqlWhereClause.combine((EWiqlWhereClauseCombinator)EWiqlWhereClauseCombinator.AND, clauses);
    }

    private static WiqlWhereClause buildContainsClauses(String field, IncludeExcludeFilterParameters filter) {
        return WiqlWhereClause.combine((EWiqlWhereClauseCombinator)EWiqlWhereClauseCombinator.AND, List.of(TfsWorkItemFilterParameters.buildContainsClause(field, filter.getIncluded()), TfsWorkItemFilterParameters.buildContainsClause(field, filter.getExcluded()).negated()));
    }

    private static WiqlWhereClause buildContainsClause(String field, Collection<String> included) {
        return WiqlWhereClause.combine((EWiqlWhereClauseCombinator)EWiqlWhereClauseCombinator.OR, included.stream().map(tag -> WiqlWhereClause.simple((String)field, (IWiqlWhereOperator.EWiqlSimpleOperator)IWiqlWhereOperator.EWiqlSimpleOperator.CONTAINS, (String)tag)).toList());
    }

    private static WiqlWhereClause buildIncludeExcludeClause(String field, IncludeExcludeRecursiveFilterParameters filter) {
        return WiqlWhereClause.combine((EWiqlWhereClauseCombinator)EWiqlWhereClauseCombinator.AND, List.of(TfsWorkItemFilterParameters.buildPathClause(field, filter.isIncludeRecursive(), filter.getIncluded()), TfsWorkItemFilterParameters.buildPathClause(field, filter.isExcludeRecursive(), filter.getExcluded()).negated()));
    }

    private static WiqlWhereClause buildPathClause(String field, boolean recursive, Collection<String> values) {
        if (recursive) {
            return WiqlWhereClause.combine((EWiqlWhereClauseCombinator)EWiqlWhereClauseCombinator.OR, values.stream().map(path -> WiqlWhereClause.simple((String)field, (IWiqlWhereOperator.EWiqlSimpleOperator)IWiqlWhereOperator.EWiqlSimpleOperator.UNDER, (String)path)).toList());
        }
        return WiqlWhereClause.collection((String)field, (IWiqlWhereOperator.EWiqlCollectionOperator)IWiqlWhereOperator.EWiqlCollectionOperator.IN, values);
    }

    public String toString() {
        return "TfsWorkItemFilterParameters{areaFilter=" + String.valueOf(this.areaFilter) + ", iterationFilter=" + String.valueOf(this.iterationFilter) + ", tagFilter=" + String.valueOf(this.tagFilter) + "}";
    }

    public static class IncludeExcludeRecursiveFilterParameters
    extends IncludeExcludeFilterParameters {
        private static final String INCLUDE_RECURSIVE_PARAMETER_NAME = "include-recursive";
        private static final String EXCLUDE_RECURSIVE_PARAMETER_NAME = "exclude-recursive";
        @StepParameter(value="include-recursive", optional=true)
        private boolean includeRecursive;
        @StepParameter(value="exclude-recursive", optional=true)
        private boolean excludeRecursive;

        public IncludeExcludeRecursiveFilterParameters() {
        }

        public IncludeExcludeRecursiveFilterParameters(Collection<String> included, boolean includeRecursive, Collection<String> excluded, boolean excludeRecursive) {
            super(included, excluded);
            this.includeRecursive = includeRecursive;
            this.excludeRecursive = excludeRecursive;
        }

        public boolean isIncludeRecursive() {
            return this.includeRecursive;
        }

        public boolean isExcludeRecursive() {
            return this.excludeRecursive;
        }

        @Override
        void setTriggerParameters(TriggerBuilder builder, String prefix) {
            super.setTriggerParameters(builder, prefix);
            builder.setTriggerParameter(prefix + INCLUDE_RECURSIVE_PARAMETER_NAME, this.includeRecursive);
            builder.setTriggerParameter(prefix + EXCLUDE_RECURSIVE_PARAMETER_NAME, this.excludeRecursive);
        }

        @Override
        public void setTriggerParameters(Map<String, Object> parameters, String prefix) {
            super.setTriggerParameters(parameters, prefix);
            parameters.put(prefix + INCLUDE_RECURSIVE_PARAMETER_NAME, this.includeRecursive);
            parameters.put(prefix + EXCLUDE_RECURSIVE_PARAMETER_NAME, this.excludeRecursive);
        }

        @Override
        public String toString() {
            return "IncludeExcludeRecursiveFilterParameters{includeRecursive=" + this.includeRecursive + ", excludeRecursive=" + this.excludeRecursive + "} " + super.toString();
        }
    }

    public static class IncludeExcludeFilterParameters {
        private static final String INCLUDED_PARAMETER_NAME = "included";
        private static final String EXCLUDED_PARAMETER_NAME = "excluded";
        @StepParameter(value="included", optional=true)
        private final Set<String> included;
        @StepParameter(value="excluded", optional=true)
        private final Set<String> excluded;

        public IncludeExcludeFilterParameters() {
            this(Collections.emptySet(), Collections.emptySet());
        }

        public IncludeExcludeFilterParameters(Collection<String> included, Collection<String> excluded) {
            this.included = new HashSet<String>(included);
            this.excluded = new HashSet<String>(excluded);
        }

        public UnmodifiableSet<String> getIncluded() {
            return CollectionUtils.asUnmodifiable(this.included);
        }

        public UnmodifiableSet<String> getExcluded() {
            return CollectionUtils.asUnmodifiable(this.excluded);
        }

        void setTriggerParameters(TriggerBuilder builder, String prefix) {
            builder.setTriggerParameter(prefix + INCLUDED_PARAMETER_NAME, ITriggerParameter.of(this.included));
            builder.setTriggerParameter(prefix + EXCLUDED_PARAMETER_NAME, ITriggerParameter.of(this.excluded));
        }

        @VisibleForTesting
        public void setTriggerParameters(Map<String, Object> parameters, String prefix) {
            parameters.put(prefix + INCLUDED_PARAMETER_NAME, this.included);
            parameters.put(prefix + EXCLUDED_PARAMETER_NAME, this.excluded);
        }

        public String toString() {
            return "IncludeExcludeFilterParameters{included=" + String.valueOf(this.included) + ", excluded=" + String.valueOf(this.excluded) + "}";
        }
    }
}

