/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.google.common.base.Preconditions;
import com.teamscale.index.merge_request.EMergeRequestBuildStatus;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.repository.git.common.BuildCompletenessStatus;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public record MergeRequestBuildPipelineInfo(boolean isBuildIncludeExcludePatternSet, List<MergeRequestBuildJob> headCommitBuildJobs) implements Serializable
{
    public static final String WAITING_FOR_BUILDS_TO_START_TEXT = "N/A";

    public MergeRequestBuildPipelineInfo {
        if (!isBuildIncludeExcludePatternSet) {
            Preconditions.checkArgument((boolean)headCommitBuildJobs.isEmpty(), (Object)"Parameter %s should be empty if %s is false.".formatted("headCommitBuildJobs", "isBuildIncludeExcludePatternSet"));
        }
    }

    public boolean isWaitingForMatchingBuildJobs() {
        return this.isBuildIncludeExcludePatternSet && this.headCommitBuildJobs.isEmpty();
    }

    private boolean hasInProgressBuildJobs() {
        return !this.headCommitBuildJobs.isEmpty() && this.headCommitBuildJobs.stream().anyMatch(job -> job.status() == EMergeRequestBuildStatus.IN_PROGRESS);
    }

    public boolean isBuildComplete() {
        return !this.isBuildIncludeExcludePatternSet || !this.isWaitingForMatchingBuildJobs() && !this.hasInProgressBuildJobs();
    }

    int getInProgressBuildJobsCount() {
        return CollectionUtils.filter(this.headCommitBuildJobs, job -> job.status() == EMergeRequestBuildStatus.IN_PROGRESS).size();
    }

    public BuildCompletenessStatus getBuildCompletenessStatus() {
        return new BuildCompletenessStatus(this.isBuildComplete(), this.headCommitBuildJobs);
    }

    public String getIncompleteWarningTextForTgaBadge() {
        if (!this.isBuildIncludeExcludePatternSet) {
            return null;
        }
        if (this.isWaitingForMatchingBuildJobs()) {
            return WAITING_FOR_BUILDS_TO_START_TEXT;
        }
        if (this.hasInProgressBuildJobs()) {
            return this.getInProgressBuildJobsCount() + "/" + this.headCommitBuildJobs.size();
        }
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MergeRequestBuildPipelineInfo that = (MergeRequestBuildPipelineInfo)other;
        return this.isBuildIncludeExcludePatternSet == that.isBuildIncludeExcludePatternSet && Objects.equals(this.headCommitBuildJobs, that.headCommitBuildJobs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isBuildIncludeExcludePatternSet, this.headCommitBuildJobs);
    }
}

