/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.MigratedZipFile;
import com.teamscale.index.backup.read.BackupImportStatus;
import com.teamscale.index.backup.read.EncryptionAwareStoreImporter;
import com.teamscale.index.repository.sap.abapsystem.AbapProjectUtils;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.crypto.EncryptedStorageHandler;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class MigrateVersion117WriteSapSystemIdToSapSystemConnection {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<String> migratedSapConfigurations = new HashSet<String>();
    private final EncryptionAwareStoreImporter storeImporter;
    private final IndexLayer transactionalMigrationIndexLayer;

    public MigrateVersion117WriteSapSystemIdToSapSystemConnection(EncryptionAwareStoreImporter storeImporter, IndexLayer transactionalMigrationIndexLayer) {
        this.storeImporter = storeImporter;
        this.transactionalMigrationIndexLayer = transactionalMigrationIndexLayer;
    }

    public void importProjectOptionsStoreAndMigrateSapSystemId(MigratedZipFile backupFile, ZipArchiveEntry entry, PublicProjectId publicProjectId, SchemaAwareStorageSystem migratingProjectStorageSystem, String storeName, BackupImportStatus.ImportProgress progress) throws StorageException, IOException, MigrationException {
        PairList<byte[], byte[]> projectOptionsStoreData = this.importStoreAndRetrieveData(backupFile, entry, publicProjectId, migratingProjectStorageSystem, storeName);
        if (projectOptionsStoreData.isEmpty()) {
            return;
        }
        String sapConfigurationId = this.extractsSapConfigurationId(publicProjectId, progress);
        if (sapConfigurationId.isEmpty()) {
            return;
        }
        String sapSystemId = MigrateVersion117WriteSapSystemIdToSapSystemConnection.extractSapSystemId(projectOptionsStoreData);
        if (sapSystemId.isEmpty()) {
            return;
        }
        this.migrateSapSystemId(sapConfigurationId, sapSystemId, progress);
    }

    private PairList<byte[], byte[]> importStoreAndRetrieveData(MigratedZipFile backupFile, ZipArchiveEntry entry, PublicProjectId publicProjectId, SchemaAwareStorageSystem migratingProjectStorageSystem, String storeName) throws IOException, StorageException {
        if (!migratingProjectStorageSystem.hasIndex(storeName)) {
            LOGGER.error("Ignored store " + storeName + " (not configured in project " + String.valueOf(publicProjectId) + ")");
            return new PairList();
        }
        IStore store = migratingProjectStorageSystem.openStore(storeName);
        try (InputStream stream = backupFile.getInputStream(entry);){
            if (this.storeImporter.isEncryptedName(entry.getName())) {
                PairList<byte[], byte[]> pairList = this.importEncryptedStoreAndRetrieveData(stream, store);
                return pairList;
            }
            BufferedInputStream in = new BufferedInputStream(stream);
            DataInputStream din = new DataInputStream(in);
            if (EncryptionAwareStoreImporter.isLikelyEncrypted(in, din)) {
                PairList<byte[], byte[]> pairList = this.importEncryptedStoreAndRetrieveData(in, store);
                return pairList;
            }
            StorageUtils.importStore((IStore)store, (DataInputStream)din);
            in.reset();
            PairList pairList = StorageUtils.readStore((DataInputStream)din);
            return pairList;
        }
    }

    private PairList<byte[], byte[]> importEncryptedStoreAndRetrieveData(InputStream in, IStore store) throws IOException, StorageException {
        byte[] data = FileSystemUtils.readStreamBinary((InputStream)in);
        byte[] decrypted = EncryptedStorageHandler.decrypt((byte[])data, (SecretKeySpec)this.storeImporter.getDecryptionKey());
        StorageUtils.importStore((IStore)store, (DataInputStream)new DataInputStream(new ByteArrayInputStream(decrypted)));
        return StorageUtils.readStore((DataInputStream)new DataInputStream(new ByteArrayInputStream(decrypted)));
    }

    private String extractsSapConfigurationId(PublicProjectId publicProjectId, BackupImportStatus.ImportProgress progress) throws StorageException {
        MetaIndex projectMetaIndex = (MetaIndex)this.transactionalMigrationIndexLayer.openProjectStorageSystem((IProjectId)publicProjectId).openProjectIndex(MetaIndex.class, null);
        ExternalCredentialsIndex externalCredentialsIndex = (ExternalCredentialsIndex)this.transactionalMigrationIndexLayer.openGlobalIndex(ExternalCredentialsIndex.class);
        Set<String> configurationIds = AbapProjectUtils.resolveSapConfigurationIdsForProject(externalCredentialsIndex, projectMetaIndex);
        String configurationId = configurationIds.stream().findFirst().orElse("");
        if (configurationIds.size() > 1) {
            progress.warn("Multiple SAP ABAP System connections identified during the migration of the SAP system ID from the project options to the SAP ABAP System Connections - Global Settings. The migration will be continued for the first identified SAP ABAP System connection '" + configurationId + "'.");
        }
        return configurationId;
    }

    private static String extractSapSystemId(PairList<byte[], byte[]> projectOptionsStoreData) {
        for (Pair projectOptionData : projectOptionsStoreData) {
            int etxIndex;
            String storeValue;
            if (!StringUtils.bytesToString((byte[])((byte[])projectOptionData.getFirst())).endsWith(":sap.system") || (storeValue = StringUtils.bytesToString((byte[])((byte[])projectOptionData.getSecond()))) == null || (etxIndex = storeValue.lastIndexOf(String.valueOf('\u0003'))) == -1) continue;
            return storeValue.substring(etxIndex).trim();
        }
        return "";
    }

    private void migrateSapSystemId(String sapConfigurationId, String sapSystemId, BackupImportStatus.ImportProgress progress) throws StorageException, MigrationException {
        String sapConfigurationIdKey;
        String errorMessage = "Failed migration of the SAP system ID '" + sapSystemId + "' from the project options to the SAP ABAP System Connection '" + sapConfigurationId + "'.";
        String infoMessage = "Successful migration of the SAP system ID '" + sapSystemId + "' from the project options to the SAP ABAP System Connection '" + sapConfigurationId + "'.";
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.transactionalMigrationIndexLayer.openGlobalIndex(ServerOptionIndex.class);
        Map<String, AbapSystemDescription> abapSystemDescriptions = AbapSystemDescription.getAllInstances(serverOptionIndex);
        AbapSystemDescription sapServerOption = abapSystemDescriptions.get(sapConfigurationIdKey = "server:sap.abap.system/" + sapConfigurationId);
        if (sapServerOption == null) {
            progress.error(errorMessage + " The SAP ABAP System Connection '" + sapConfigurationId + "' does not exist.");
            return;
        }
        if (sapServerOption.jcoR3Name.isEmpty()) {
            this.migrateSapSystemIdAndLogSuccessfulMigration(sapServerOption, sapSystemId, sapConfigurationId, serverOptionIndex, progress, infoMessage);
        } else {
            this.checkSapSystemIdInSystemConnectionAndLogMigrationResult(sapServerOption, sapSystemId, sapConfigurationId, progress, errorMessage, infoMessage);
        }
    }

    private void migrateSapSystemIdAndLogSuccessfulMigration(AbapSystemDescription sapServerOption, String sapSystemId, String sapConfigurationId, ServerOptionIndex serverOptionIndex, BackupImportStatus.ImportProgress progress, String infoMessage) throws StorageException {
        sapServerOption.jcoR3Name = sapSystemId;
        ServerOptionRegistry.getInstance().putOption("server", "sap.abap.system", sapConfigurationId, (IOption)sapServerOption, (OptionIndexBase)serverOptionIndex);
        this.migratedSapConfigurations.add(sapConfigurationId);
        progress.info(infoMessage);
    }

    private void checkSapSystemIdInSystemConnectionAndLogMigrationResult(AbapSystemDescription sapServerOption, String sapSystemId, String sapConfigurationId, BackupImportStatus.ImportProgress progress, String errorMessage, String infoMessage) throws MigrationException {
        if (!sapServerOption.jcoR3Name.equals(sapSystemId) && this.migratedSapConfigurations.contains(sapConfigurationId)) {
            errorMessage = (String)errorMessage + " The SAP system id '" + sapServerOption.jcoR3Name + "', which was already migrated during this backup import to the SAP ABAP System Connection'" + sapConfigurationId + "' does not match '" + sapSystemId + "'.";
            MigrateVersion117WriteSapSystemIdToSapSystemConnection.handleFailedMigration(progress, (String)errorMessage);
        } else if (!sapServerOption.jcoR3Name.equals(sapSystemId)) {
            errorMessage = (String)errorMessage + " The SAP system id '" + sapServerOption.jcoR3Name + "' configured in the SAP ABAP System Connection '" + sapConfigurationId + "' does not match '" + sapSystemId + "'.";
            MigrateVersion117WriteSapSystemIdToSapSystemConnection.handleFailedMigration(progress, (String)errorMessage);
        } else if (this.migratedSapConfigurations.contains(sapConfigurationId)) {
            progress.info(infoMessage);
        }
    }

    private static void handleFailedMigration(BackupImportStatus.ImportProgress progress, String errorMessage) throws MigrationException {
        progress.error(errorMessage);
        progress.setStatus(EBackupStatus.FAILURE);
        progress.setStatusMessage("Import failed! Error during migration of project options.");
        throw new MigrationException(errorMessage);
    }
}

