/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion158TrimExternalAccountCredentialsName
extends SerializedValueMigratorBase {
    private static final String SERIALIZED_CLASS_NAME = "com.teamscale.core.accounts.ExternalCredentials";
    private static final String CREDENTIALS_NAME_FIELD_NAME = "credentialsName";

    public MigrateVersion158TrimExternalAccountCredentialsName() {
        super(true);
    }

    public String getStoreName() {
        return "external-credentials";
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V158;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        for (SerializedObject externalCredentials : SerializedEntityUtils.findInstancesOf((SerializedClass)entityPool.findClass(SERIALIZED_CLASS_NAME), (SerializedEntityPool)entityPool)) {
            Integer credentialName;
            SerializedStringObject stringEntity;
            Object credentialsFieldValue = externalCredentials.getFieldValue(CREDENTIALS_NAME_FIELD_NAME);
            if (!(credentialsFieldValue instanceof Integer) || (stringEntity = (SerializedStringObject)entityPool.getEntity((credentialName = (Integer)credentialsFieldValue).intValue(), SerializedStringObject.class)) == null) continue;
            stringEntity.setValue(stringEntity.getValue().trim());
        }
    }

    protected byte[] migrateKey(byte[] key) {
        String credentialsName = StringUtils.bytesToString((byte[])key).trim();
        return StringUtils.stringToBytes((String)credentialsName);
    }
}

