/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import java.util.Set;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.intellij.lang.annotations.Language;

public class ProjectVersion51RemoveUnsupportedConnectorOptions {
    private static final Set<String> CONNECTOR_TYPES_WITHOUT_PATH_SUFFIX = Set.of("GitHub", "Bitbucket Cloud", "GitLab", "Azure DevOps Git", "Gitea", "Bitbucket Data Center (On-Premise)", "SCM-Manager", "Artificial Merge Request Connector");
    private static final Set<String> CONNECTOR_TYPES_WITHOUT_SSH_KEY = Set.of("Artificial Merge Request Connector", "SCM-Manager", "Bitbucket Data Center (On-Premise)", "Gitea", "Azure DevOps Git", "GitHub", "Bitbucket Cloud");
    private static final Set<String> CONNECTOR_TYPES_WITHOUT_BUILD_COMPLETENESS = Set.of("Artificial Merge Request Connector", "SCM-Manager", "Gitea", "Azure DevOps Git", "Bitbucket Cloud");

    public static String migrate(@Language(value="JSON") String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        for (ConnectorConfiguration connector : holder.connectors) {
            if (CONNECTOR_TYPES_WITHOUT_PATH_SUFFIX.contains(connector.getType())) {
                connector.removeOption("Path suffix");
            }
            if (CONNECTOR_TYPES_WITHOUT_SSH_KEY.contains(connector.getType())) {
                connector.removeOption("SSH Private Key ID");
            }
            if (!CONNECTOR_TYPES_WITHOUT_BUILD_COMPLETENESS.contains(connector.getType())) continue;
            connector.removeOption("Included build jobs");
            connector.removeOption("Excluded build jobs");
            connector.removeOption("Build polling interval");
        }
        return JsonUtils.serializeToJSON((Object)holder);
    }
}

