/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v123_compile_commands;

import com.teamscale.index.migration.v123_compile_commands.V123ETokenType;
import com.teamscale.index.migration.v123_compile_commands.V123IToken;

public abstract class V123Token
implements V123IToken {
    private static final long serialVersionUID = 1L;
    protected final V123ETokenType type;
    protected final int offset;
    protected final int lineNumber;
    protected final String text;
    protected final String originId;

    protected V123Token(V123ETokenType type, long offset, int lineNumber, String text, String originId) {
        this.type = type;
        this.offset = (int)offset;
        this.lineNumber = lineNumber;
        this.text = text;
        this.originId = originId;
    }

    public String toString() {
        String result = "TOKEN (" + String.valueOf((Object)this.type) + ") Text: >>" + this.text + "<<";
        result = result + " Origin: '" + this.originId + "' line#: " + this.lineNumber + " offset: " + this.offset;
        return result;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getEndOffset() {
        return this.offset + this.text.length() - 1;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getOriginId() {
        return this.originId;
    }

    @Override
    public V123ETokenType getType() {
        return this.type;
    }
}

