/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.precommit;

import java.util.OptionalLong;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="user-precommit-timestamp", valueClasses={Long.class})
public class PreCommitUserInfoIndex
extends IndexBase
implements IGlobalIndex {
    public static final String INDEX_NAME = "user-precommit-timestamp";

    public PreCommitUserInfoIndex(IStore store) {
        super(store);
    }

    public OptionalLong getLastUpload(String user, PublicProjectId project) throws StorageException {
        return ByteArrayUtils.byteArrayToOptionalLong((byte[])this.store.getWithString(PreCommitUserInfoIndex.makeLastUploadKey(user, project)));
    }

    public void setLastUpload(String user, PublicProjectId project, long timestamp) throws StorageException {
        this.store.putWithString(PreCommitUserInfoIndex.makeLastUploadKey(user, project), ByteArrayUtils.longToByteArray((long)timestamp));
    }

    private static String makeLastUploadKey(String user, PublicProjectId project) {
        return "last::" + user + "::" + String.valueOf(project);
    }
}

