/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.SlideRenderDataBase;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.ESlideOptionType;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SlideCommentRenderData;
import com.teamscale.index.quality_report.slides.SlideParameter;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import com.teamscale.index.task.ETaskStatus;
import com.teamscale.index.task.Task;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class TasksSlide
extends ReportSlideBase<TasksSlideParameters, TasksSlideResult> {
    private static final long serialVersionUID = 1L;

    @Override
    public EReportSlide getSlideType() {
        return EReportSlide.TASKS;
    }

    @ExportToTypeScript
    @IndexValueClass(containedInBackup=true)
    public static enum EBaselineRelation {
        BEFORE("Before baseline"),
        AFTER("After baseline");

        private final String readableName;

        private EBaselineRelation(String readableName) {
            this.readableName = readableName;
        }

        public String getReadableName() {
            return this.readableName;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class TasksSlideResult
    extends SlideRenderDataBase {
        private static final long serialVersionUID = 1L;
        private static final String PROPERTY_COMMENTS = "comments";
        private static final String PROPERTY_PROJECT_OR_ALIAS = "projectOrAlias";
        private static final String PROPERTY_TASKS = "tasks";
        @JsonProperty(value="tasks")
        private List<Task> tasks;
        @JsonProperty(value="projectOrAlias")
        private String projectOrAlias;
        @JsonProperty(value="comments")
        private List<SlideCommentRenderData> comments;

        @JsonCreator
        public TasksSlideResult(@JsonProperty(value="tasks") List<Task> tasks, @JsonProperty(value="projectOrAlias") String projectId, @JsonProperty(value="comments") List<SlideCommentRenderData> comments) {
            this.tasks = tasks;
            this.projectOrAlias = projectId;
            this.comments = comments;
        }

        public List<SlideCommentRenderData> getComments() {
            return this.comments;
        }

        public List<Task> getTasks() {
            return this.tasks;
        }

        public PublicProjectId getProjectId() {
            if (StringUtils.isEmpty((String)this.projectOrAlias)) {
                return null;
            }
            return new PublicProjectId(this.projectOrAlias);
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class TasksSlideParameters
    extends SlideParametersBase {
        private static final long serialVersionUID = 1L;
        @SlideParameter(formattedName="Project", type=ESlideOptionType.PROJECT)
        @JsonProperty(value="projectBranchPath")
        private @Nullable ProjectBranchPath projectBranchPath;
        @SlideParameter(formattedName="Title", inputHint="Markdown supported", type=ESlideOptionType.STRING)
        @JsonProperty(value="slideTitle")
        private String slideTitle;
        @SlideParameter(formattedName="Status", type=ESlideOptionType.TASK_STATUSES)
        @JsonProperty(value="taskStatuses")
        private List<ETaskStatus> taskStatuses;
        @SlideParameter(formattedName="Tags Filter", type=ESlideOptionType.TASK_TAGS)
        @JsonProperty(value="taskTags")
        private List<String> taskTags;
        @SlideParameter(formattedName="Include Tasks", type=ESlideOptionType.MULTISELECT_TASKS)
        @JsonProperty(value="baselineRelation")
        private List<EBaselineRelation> baselineRelation;
        @SlideParameter(formattedName="Comments", inputHint="Markdown supported", type=ESlideOptionType.COMMENTS)
        @JsonProperty(value="comments")
        private List<ISlideComment> comments;

        @JsonCreator
        TasksSlideParameters() {
        }

        @VisibleForTesting
        public TasksSlideParameters(ProjectBranchPath projectBranchPath, String slideTitle, List<ETaskStatus> taskStatuses, List<EBaselineRelation> baselineRelation, List<ISlideComment> comments, List<String> taskTags) {
            this.projectBranchPath = projectBranchPath;
            this.slideTitle = slideTitle;
            this.taskStatuses = taskStatuses;
            this.baselineRelation = baselineRelation;
            this.comments = comments;
            this.taskTags = taskTags;
        }

        @Override
        public List<PublicProjectId> getReferencedProjects() {
            if (this.projectBranchPath == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.projectBranchPath.getProjectId());
        }

        public List<ISlideComment> getComments() {
            return this.comments;
        }

        public ProjectBranchPath getProjectBranchPath() {
            return this.projectBranchPath;
        }

        public List<ETaskStatus> getTaskStatuses() {
            return this.taskStatuses;
        }

        public List<EBaselineRelation> getBaselineRelation() {
            return this.baselineRelation;
        }

        public String getSlideTitle() {
            return this.slideTitle;
        }

        public void setProjectBranchPath(ProjectBranchPath projectBranchPath) {
            this.projectBranchPath = projectBranchPath;
        }

        public void setSlideTitle(String slideTitle) {
            this.slideTitle = slideTitle;
        }

        public void setTaskStatuses(List<ETaskStatus> taskStatuses) {
            this.taskStatuses = taskStatuses;
        }

        public void setBaselineRelation(List<EBaselineRelation> baselineRelation) {
            this.baselineRelation = baselineRelation;
        }

        public List<String> getTaskTags() {
            return this.taskTags;
        }

        public void setTaskTags(List<String> taskTags) {
            this.taskTags = taskTags;
        }
    }
}

