/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.astree;

import com.teamscale.index.report.astree.AstreeAlarmCategory;
import com.teamscale.index.report.astree.AstreeAlarmMessage;
import com.teamscale.index.report.astree.AstreeAlarmType;
import com.teamscale.index.report.astree.AstreeFile;
import com.teamscale.index.report.astree.AstreeLocation;
import com.teamscale.index.report.astree.AstreeReportParserUtils;
import com.teamscale.index.report.astree.EAstreeReportXmlElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class AstreeReportHandler
extends DefaultHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<AstreeAlarmMessage> alarmMessages = new ArrayList<AstreeAlarmMessage>();
    private final List<AstreeFile> files = new ArrayList<AstreeFile>();
    private final List<AstreeLocation> locations = new ArrayList<AstreeLocation>();
    private final List<AstreeAlarmType> alarmTypes = new ArrayList<AstreeAlarmType>();
    private final List<AstreeAlarmCategory> alarmCategories = new ArrayList<AstreeAlarmCategory>();
    private AstreeAlarmMessage currentAlarmMessage = null;
    private AstreeAlarmMessage.TextLine currentTextLine = null;
    private AstreeAlarmType currentAlarmType = null;
    private AstreeAlarmCategory currentAlarmCategory = null;
    private final StringBuilder textContent = new StringBuilder();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.textContent.setLength(0);
        EAstreeReportXmlElement element = AstreeReportHandler.getElementType(localName);
        if (element == null) {
            return;
        }
        switch (element) {
            case ALARM_MESSAGE: 
            case ERROR_MESSAGE: {
                this.handleAlarmMessageStart(attributes);
                break;
            }
            case TEXTLINE: {
                this.handleTextLineStart(attributes);
                break;
            }
            case FILE: {
                this.handleFile(attributes);
                break;
            }
            case LOCATION: {
                this.handleLocation(attributes);
                break;
            }
            case ALARM_TYPE: {
                this.handleAlarmTypeStart(attributes);
                break;
            }
            case ALARM_CATEGORY: {
                this.handleAlarmCategoryStart(attributes);
                break;
            }
        }
    }

    private static <T> Optional<T> createFromAttributes(Class<T> resultClass, Attributes attributes, Function<Attributes, Optional<T>> creator) {
        Optional<T> result = creator.apply(attributes);
        if (!result.isPresent()) {
            LOGGER.warn("Unable to create {} from attributes: {}", (Object)resultClass.getSimpleName(), (Object)AstreeReportParserUtils.getAttributesAsString(attributes));
        }
        return result;
    }

    private void handleAlarmCategoryStart(Attributes attributes) {
        AstreeReportHandler.createFromAttributes(AstreeAlarmCategory.class, attributes, AstreeAlarmCategory::createFrom).ifPresent(this::setCurrentAlarmCategory);
    }

    private void setCurrentAlarmCategory(AstreeAlarmCategory currentAlarmCategory) {
        this.currentAlarmCategory = currentAlarmCategory;
    }

    private void handleAlarmTypeStart(Attributes attributes) {
        AstreeReportHandler.createFromAttributes(AstreeAlarmType.class, attributes, AstreeAlarmType::createFrom).ifPresent(this::setCurrentAlarmType);
    }

    private void setCurrentAlarmType(AstreeAlarmType currentAlarmType) {
        this.currentAlarmType = currentAlarmType;
    }

    private void handleLocation(Attributes attributes) {
        AstreeReportHandler.createFromAttributes(AstreeLocation.class, attributes, AstreeLocation::createFrom).ifPresent(this.locations::add);
    }

    private void handleFile(Attributes attributes) {
        AstreeReportHandler.createFromAttributes(AstreeFile.class, attributes, AstreeFile::createFrom).ifPresent(this.files::add);
    }

    private void handleTextLineStart(Attributes attributes) {
        AstreeReportHandler.createFromAttributes(AstreeAlarmMessage.TextLine.class, attributes, AstreeAlarmMessage.TextLine::createFrom).ifPresent(this::setCurrentTextLine);
    }

    private void setCurrentTextLine(AstreeAlarmMessage.TextLine currentTextLine) {
        this.currentTextLine = currentTextLine;
    }

    private void handleAlarmMessageStart(Attributes attributes) {
        AstreeReportHandler.createFromAttributes(AstreeAlarmMessage.class, attributes, AstreeAlarmMessage::createFrom).ifPresent(this::setCurrentAlarmMessage);
    }

    private void setCurrentAlarmMessage(AstreeAlarmMessage currentAlarmMessage) {
        this.currentAlarmMessage = currentAlarmMessage;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        EAstreeReportXmlElement element = AstreeReportHandler.getElementType(localName);
        if (element == null) {
            return;
        }
        switch (element) {
            case ALARM_MESSAGE: 
            case ERROR_MESSAGE: {
                this.handleAlarmMessageEnd();
                break;
            }
            case TEXTLINE: {
                this.handleTextLineEnd();
                break;
            }
            case ALARM_TYPE: {
                this.handleAlarmTypeEnd();
                break;
            }
            case ALARM_CATEGORY: {
                this.handleAlarmCategoryEnd();
                break;
            }
        }
    }

    private void handleAlarmCategoryEnd() {
        if (this.currentAlarmCategory != null) {
            this.currentAlarmCategory.setName(this.currentText());
            this.alarmCategories.add(this.currentAlarmCategory);
            this.currentAlarmCategory = null;
        }
    }

    private void handleAlarmTypeEnd() {
        if (this.currentAlarmType != null) {
            this.currentAlarmType.setName(this.currentText());
            this.alarmTypes.add(this.currentAlarmType);
            this.currentAlarmType = null;
        }
    }

    private void handleTextLineEnd() {
        if (this.currentTextLine != null) {
            this.currentTextLine.setContent(this.currentText());
            this.currentAlarmMessage.addTextLine(this.currentTextLine);
            this.currentTextLine = null;
        }
    }

    private static EAstreeReportXmlElement getElementType(String localName) {
        return (EAstreeReportXmlElement)EAstreeReportXmlElement.VALUES.valueOf(localName.toUpperCase());
    }

    private void handleAlarmMessageEnd() {
        if (this.currentAlarmMessage != null) {
            this.alarmMessages.add(this.currentAlarmMessage);
        }
    }

    private String currentText() {
        return this.textContent.toString().trim();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.textContent.append(ch, start, length);
    }

    public List<AstreeAlarmMessage> getAlarmMessages() {
        return this.alarmMessages;
    }

    public List<AstreeFile> getFiles() {
        return this.files;
    }

    public List<AstreeLocation> getLocations() {
        return this.locations;
    }

    public List<AstreeAlarmCategory> getAlarmCategories() {
        return this.alarmCategories;
    }

    public List<AstreeAlarmType> getAlarmTypes() {
        return this.alarmTypes;
    }
}

