/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.external.result.ExternalAnalysisResultSimulinkCodeGeneration;
import com.teamscale.index.report.parser.SimulinkMatFileReportParser;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.index.simulink.tracing.SimulinkPlcCoderTraceIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ExternalAnalysisSimulinkCodeGenerationTracesProcessor
extends ExternalAnalysisResultProcessorBase<ExternalAnalysisResultSimulinkCodeGeneration> {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SimulinkPlcCoderTraceIndex plcCoderTraceIndex;
    private Map<String, QualifiedNameLocation> codeToSimulinkTraces = new HashMap<String, QualifiedNameLocation>();

    @Override
    public boolean isRelevantPath(UniformPath uniformPath) {
        return SimulinkMatFileReportParser.isPlcCoderTraceInfoFile(uniformPath);
    }

    @Override
    public Class<ExternalAnalysisResultSimulinkCodeGeneration> getResultClass() {
        return ExternalAnalysisResultSimulinkCodeGeneration.class;
    }

    @Override
    public boolean extract(String partition, UniformPath uniformPath, ExternalAnalysisResultSimulinkCodeGeneration analysisResult, CommitDescriptor resultsCommit, CommitDescriptor resultsForCommit, BasicTokenElementInfo element) {
        this.codeToSimulinkTraces = analysisResult.getData().codeToSimulinkLocationLinks;
        return true;
    }

    @Override
    public void persist(CommitDescriptor commit) throws StorageException {
        this.plcCoderTraceIndex.overwriteWithNewSimulinkTraces(this.codeToSimulinkTraces);
    }

    @Override
    public void processDeleted(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
        if (deletedPartitionAndPaths.stream().anyMatch(partitionAndPath -> SimulinkMatFileReportParser.isPlcCoderTraceInfoFile(partitionAndPath.getUniformPath()))) {
            this.plcCoderTraceIndex.overwriteWithNewSimulinkTraces(Collections.emptyMap());
        }
    }

    @Override
    public void reset() {
        this.codeToSimulinkTraces.clear();
    }
}

