/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.testexecution;

import com.google.common.base.Preconditions;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoTestExecution;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.report.parser.IPathPrefixedReportParser;
import com.teamscale.index.report.parser.ReportParserBase;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.Nullable;

public abstract class TestReportParserBase
extends ReportParserBase
implements IPathPrefixedReportParser {
    private @Nullable String pathPrefix = null;
    private ExternalAnalysisImportInfos importInfos = new ExternalAnalysisImportInfos();

    @Override
    protected void resetState() {
        super.resetState();
        this.importInfos = new ExternalAnalysisImportInfos();
    }

    @Override
    protected ExternalAnalysisImportInfos convertToImportInfos() {
        return this.importInfos;
    }

    protected void reportTestExecution(TestExecution.Builder builder) {
        UniformPath testExecutionPath = TestReportParserBase.prependPathPrefixToTestExecutionPath(builder.getUniformPath(), this.pathPrefix);
        builder = builder.fromBuilder(testExecutionPath);
        this.importInfos.addInfo(new ExternalAnalysisImportInfoTestExecution(testExecutionPath.toString(), builder.build(), false));
    }

    private static UniformPath prependPathPrefixToTestExecutionPath(UniformPath testPath, @Nullable String pathPrefix) {
        Preconditions.checkArgument((boolean)testPath.isTestExecutionPath());
        if (pathPrefix == null) {
            return testPath;
        }
        return UniformPath.testExecutionRoot().resolve(UniformPathCompatibilityUtil.convertRelative((String)pathPrefix)).resolve(testPath.getSubPath(0));
    }

    @Override
    public void setPathPrefix(@Nullable String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }
}

