/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.api.progress.IProjectAnalysisProgressListener;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import io.prometheus.metrics.core.datapoints.DistributionDataPoint;
import io.prometheus.metrics.core.metrics.Histogram;
import io.prometheus.metrics.model.snapshots.Unit;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public class PrometheusMonitoringProgressListener
implements IProjectAnalysisProgressListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Histogram ANALYSIS_PERFORMANCE_HISTOGRAM = PrometheusMonitoringProgressListener.createHistogram();

    private static Histogram createHistogram() {
        Histogram.Builder commitAnalysisTime = (Histogram.Builder)((Histogram.Builder)Histogram.builder().name("commit_analysis_duration_seconds")).help("Time it takes to analyze a commit, from the first time it was discovered by Teamscale to the last trigger execution.");
        commitAnalysisTime.labelNames(new String[]{"project", "type", "analysis_state"});
        commitAnalysisTime.withExemplars();
        commitAnalysisTime.classicUpperBounds(PrometheusMonitoringProgressListener.durationToSeconds(Duration.ofSeconds(10L), Duration.ofSeconds(30L), Duration.ofMinutes(1L), Duration.ofMinutes(5L), Duration.ofMinutes(10L), Duration.ofMinutes(30L), Duration.ofHours(1L), Duration.ofHours(2L), Duration.ofHours(4L), Duration.ofHours(8L)));
        commitAnalysisTime.unit(Unit.SECONDS);
        return (Histogram)commitAnalysisTime.register();
    }

    private static double[] durationToSeconds(Duration ... durations) {
        return Arrays.stream(durations).mapToDouble(Duration::toSeconds).toArray();
    }

    public void reportCompletedRevision(EAnalysisState analysisState, CommitDescriptor completedCommit, @Nullable ProjectStorageSystem projectStorageSystem, @Nullable PublicProjectId primaryProjectId) {
        if (projectStorageSystem == null) {
            return;
        }
        try {
            PrometheusMonitoringProgressListener.reportMetricsToPrometheus(analysisState, completedCommit, projectStorageSystem, primaryProjectId);
        }
        catch (RuntimeException | StorageException e) {
            LOGGER.error("Could not report revision completion to Prometheus", e);
        }
    }

    private static void reportMetricsToPrometheus(EAnalysisState analysisState, CommitDescriptor completedCommit, ProjectStorageSystem projectStorageSystem, PublicProjectId primaryProjectId) throws StorageException {
        if (!projectStorageSystem.hasIndex(RepositoryLogIndex.class)) {
            return;
        }
        ICommitTreeNode commitTreeNode = PrometheusMonitoringProgressListener.getCommitTreeNode(completedCommit, projectStorageSystem);
        if (commitTreeNode == null) {
            return;
        }
        RepositoryLogEntryAggregate entry = (RepositoryLogEntryAggregate)((RepositoryLogIndex)projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null)).getEntry(completedCommit);
        if (entry == null) {
            return;
        }
        String commitType = PreCommitUtils.isPrecommitCommit((CommitDescriptor)completedCommit) ? "Pre-Commit" : entry.getCommitTypes().stream().max(Comparator.naturalOrder()).orElse(ECommitType.CODE_COMMIT).readableName;
        ((DistributionDataPoint)ANALYSIS_PERFORMANCE_HISTOGRAM.labelValues(new String[]{String.valueOf(primaryProjectId), commitType, analysisState.name()})).observe((double)(System.currentTimeMillis() - commitTreeNode.getDiscoveryTimestamp()) / 1000.0);
    }

    private static @Nullable ICommitTreeNode getCommitTreeNode(CommitDescriptor completedCommit, ProjectStorageSystem projectStorageSystem) throws StorageException {
        List commitTrees = CommitTreeIndex.listCommitTrees((ProjectStorageSystem)projectStorageSystem).extractSecondList();
        for (ICommitTree commitTree : commitTrees) {
            Optional<ICommitTreeNode> first = commitTree.getAllNodes().stream().filter(node -> node.getState() != ECommitTreeNodeState.UNPROCESSED).filter(node -> node.getAdjustedCommitDescriptor().equals((Object)completedCommit)).findFirst();
            if (!first.isPresent()) continue;
            return first.get();
        }
        return null;
    }
}

