/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class RepositoryCommitMappingIndexBase
extends IndexBase {
    private static final byte[] COMMIT_KEY_PREFIX = new byte[]{99};
    public static final byte[] ID_KEY_PREFIX = new byte[]{105};

    protected RepositoryCommitMappingIndexBase(IStore store) {
        super(store);
    }

    protected void addValues(SetMap<CommitDescriptor, String> commitsToIds) throws StorageException {
        PairList values = new PairList();
        this.addIdsToCommits(commitsToIds, (PairList<byte[], byte[]>)values);
        this.addCommitsToIds(commitsToIds, (PairList<byte[], byte[]>)values);
        this.store.put(values);
    }

    private void addCommitsToIds(SetMap<CommitDescriptor, String> commitsToIds, PairList<byte[], byte[]> values) throws StorageException {
        SetMap idsToCommits = commitsToIds.invert();
        UnmodifiableSet newIds = idsToCommits.getKeys();
        SetMap<String, CommitDescriptor> existingMappings = this.getCommitsForIds((Collection<String>)newIds);
        for (String id : newIds) {
            HashSet commitsForId = new HashSet(idsToCommits.getCollection((Object)id));
            if (existingMappings.containsCollection((Object)id)) {
                commitsForId.addAll(existingMappings.getCollection((Object)id));
            }
            values.add((Object)RepositoryCommitMappingIndexBase.makeIdKey(id), (Object)StorageUtils.serialize((Serializable)CollectionUtils.sort(commitsForId)));
        }
    }

    private void addIdsToCommits(SetMap<CommitDescriptor, String> commitsToIds, PairList<byte[], byte[]> values) throws StorageException {
        List<List<String>> existingIdsForCommit = this.getIdsForCommits((Collection<CommitDescriptor>)commitsToIds.getKeys());
        CollectionUtils.forEachWithException((Collection)commitsToIds.getKeys(), existingIdsForCommit, (commit, existingIds) -> {
            HashSet allIds = new HashSet();
            if (existingIds != null) {
                allIds.addAll(existingIds);
            }
            allIds.addAll(commitsToIds.getCollection(commit));
            values.add((Object)RepositoryCommitMappingIndexBase.makeCommitKey(commit), (Object)StorageUtils.serialize((Serializable)CollectionUtils.sort(allIds)));
        });
    }

    private static byte[] makeCommitKey(CommitDescriptor commit) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{COMMIT_KEY_PREFIX, commit.toBranchTimestampKey()});
    }

    private static byte[] makeIdKey(String id) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ID_KEY_PREFIX, StringUtils.stringToBytes((String)id)});
    }

    public static Set<String> extractIssueIdsFromStoreKeys(List<StorageKey> storeKeys) {
        return new HashSet<String>(CollectionUtils.filterAndMap(storeKeys, storeKey -> storeKey != null && ByteArrayUtils.isPrefix((byte[])ID_KEY_PREFIX, (byte[])storeKey.getKey()), storeKey -> StringUtils.bytesToString((byte[])ByteArrayUtils.removePrefix((byte[])ID_KEY_PREFIX, (byte[])storeKey.getKey()))));
    }

    protected List<CommitDescriptor> getCommitsForId(String id) throws StorageException {
        byte[] value = this.store.get(RepositoryCommitMappingIndexBase.makeIdKey(id));
        if (value == null) {
            return Collections.emptyList();
        }
        return (List)((Object)StorageUtils.deserialize((byte[])value));
    }

    protected SetMap<String, CommitDescriptor> getCommitsForIds(Collection<String> ids) throws StorageException {
        ArrayList<String> orderedIds = new ArrayList<String>(ids);
        List keys = CollectionUtils.map(orderedIds, RepositoryCommitMappingIndexBase::makeIdKey);
        List values = this.store.get(keys);
        SetMap result = new SetMap();
        for (int i = 0; i < values.size(); ++i) {
            List commits = (List)((Object)StorageUtils.deserialize((byte[])((byte[])values.get(i))));
            if (commits != null) {
                result.addAll((Object)((String)orderedIds.get(i)), (Collection)commits);
                continue;
            }
            result.addAll((Object)((String)orderedIds.get(i)), new ArrayList());
        }
        return result;
    }

    protected List<String> getIdsForCommit(CommitDescriptor commit) throws StorageException {
        return this.getIdsForCommits(Collections.singletonList(commit)).get(0);
    }

    protected List<List<String>> getIdsForCommits(Collection<CommitDescriptor> commits) throws StorageException {
        List keys = CollectionUtils.map(commits, RepositoryCommitMappingIndexBase::makeCommitKey);
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (byte[] value : this.store.get(keys)) {
            result.add((List)((Object)StorageUtils.deserialize((byte[])value)));
        }
        return result;
    }
}

