/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.dependencies.abap.AbapThirdPartyPathsSynchronizer;
import com.teamscale.index.resource.EExtendedResourceType;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.CommonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.resource.text.filter.base.Deletion;
import org.conqat.engine.sourcecode.pattern.EnumPatternMatcher;
import org.conqat.engine.sourcecode.pattern.TokenTypePattern;
import org.conqat.lib.commons.error.ExceptionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class RepositoryContentUpdaterFilteringSupport {
    public static final String CONTENT_EXCLUDE_PATTERN_PARAMETER = "content-exclude-pattern";
    public static final String TEXT_FILTER_PATTERN_PARAMETER = "text-filter-pattern";
    public static final String MAX_FILE_SIZE_PARAMETER = "max-file-size";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CS_GENERATED_METHOD_NAME = "InitializeComponent";
    @StepParameter(value="content-exclude-pattern", optional=true)
    private final List<String> contentExcludePatterns = new ArrayList<String>();
    private PatternList compiledContentExcludePatterns;
    @StepParameter(value="text-filter-pattern", optional=true)
    public final List<String> filterPatterns = new ArrayList<String>();
    private PatternList compiledFilterPatterns;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    public ExtendedResourceTypeIndex resourceTypeIndex;
    @StepParameter(value="max-file-size", optional=true)
    private String maximumFileSizeInput;
    private long maximumBytesPerFile = -1L;

    public List<Deletion> determineDeletions(String uniformPath, String textContent, ELanguage language) throws ConQATException {
        ArrayList<Deletion> deletions = new ArrayList<Deletion>();
        ArrayList<String> contentExcludedPaths = new ArrayList<String>();
        if (this.isContentExcluded(language, textContent, uniformPath)) {
            deletions.add(new Deletion(0, textContent.length(), true));
            contentExcludedPaths.add(uniformPath);
        } else {
            RepositoryContentUpdaterFilteringSupport.filterLanguageSpecificMethods(uniformPath, textContent, deletions, language);
            deletions.addAll(this.calculateTextExclusions(uniformPath, textContent));
        }
        this.resourceTypeIndex.addResourceType(contentExcludedPaths, EExtendedResourceType.CONTENT_EXCLUDED);
        return Deletion.compactDeletions(deletions);
    }

    public static void filterLanguageSpecificMethods(String uniformPath, String textContent, List<Deletion> deletions, ELanguage language) {
        switch (language) {
            case ABAP: {
                RepositoryContentUpdaterFilteringSupport.filterAbapManagedDbProcedures(uniformPath, textContent, deletions);
                break;
            }
            case CS: {
                RepositoryContentUpdaterFilteringSupport.filterGeneratedCsMethods(uniformPath, textContent, deletions);
                break;
            }
        }
    }

    private List<Deletion> calculateTextExclusions(String uniformPath, String textContent) throws ConQATException {
        if (this.compiledFilterPatterns == null) {
            this.compiledFilterPatterns = new PatternList();
            for (String pattern : this.filterPatterns) {
                this.compiledFilterPatterns.add((Object)CommonUtils.compilePattern((String)pattern));
            }
        }
        ArrayList<Deletion> deletions = new ArrayList<Deletion>();
        for (Pattern filterPattern : this.compiledFilterPatterns) {
            try {
                Matcher matcher = filterPattern.matcher(textContent);
                while (matcher.find()) {
                    deletions.add(new Deletion(matcher.start(), matcher.end(), true));
                }
            }
            catch (StackOverflowError e) {
                ExceptionUtils.trimStackOverFlowTrace((StackOverflowError)e);
                LOGGER.error("Stack overflow occurred while trying to match " + filterPattern.pattern() + " against the content of " + uniformPath + ". Try to simplify the text filter pattern or exclude the file from the analysis!", (Throwable)e);
            }
        }
        return deletions;
    }

    private static void filterAbapManagedDbProcedures(String uniformPath, String textContent, List<Deletion> deletions) {
        List tokens = ScannerUtils.getTokens((String)textContent, (ELanguage)ELanguage.ABAP, (String)uniformPath);
        TokenTypePattern amdpPattern = new TokenTypePattern("<" + String.valueOf(ETokenType.AMDP) + ">");
        EnumPatternMatcher matcher = amdpPattern.matcher(tokens);
        while (matcher.find()) {
            int amdpTokenIndex = matcher.start();
            int endMethodIndex = amdpTokenIndex + 1;
            if (endMethodIndex >= tokens.size() || ((IToken)tokens.get(endMethodIndex)).getType() != ETokenType.ENDMETHOD) {
                LOGGER.error("Unable to filter ABAP managed DB procedure in %s.\nProbably due to a problem when scanning the contents of the file.\nPlease take a look at the parse log for more information.".formatted(uniformPath));
                return;
            }
            int bodyStartOffset = ((IToken)tokens.get(amdpTokenIndex)).getOffset();
            int bodyEndOffset = ((IToken)tokens.get(endMethodIndex)).getOffset();
            deletions.add(new Deletion(bodyStartOffset, bodyEndOffset, true));
        }
    }

    private static void filterGeneratedCsMethods(String uniformPath, String textContent, List<Deletion> deletions) {
        List entities;
        List tokens = ScannerUtils.getTokens((String)textContent, (ELanguage)ELanguage.CS, (String)uniformPath);
        try {
            entities = ShallowParserFactory.createParser((ELanguage)ELanguage.CS).parseTopLevel(tokens);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing file for filtering generated methods: " + uniformPath, (Throwable)e);
            return;
        }
        for (ShallowEntity method : ShallowEntityTraversalUtils.selectEntities((Collection)entities, RepositoryContentUpdaterFilteringSupport::isCsGeneratedMethod)) {
            int startOffset = method.getStartOffset();
            int endOffset = method.getEndOffset();
            if (endOffset < startOffset) continue;
            deletions.add(new Deletion(startOffset, endOffset + 1, true));
        }
    }

    private static boolean isCsGeneratedMethod(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.METHOD) {
            return false;
        }
        return CS_GENERATED_METHOD_NAME.equals(entity.getName());
    }

    private boolean isContentExcluded(ELanguage language, String content, String uniformPath) throws ConQATException {
        if (this.compiledContentExcludePatterns == null) {
            this.compiledContentExcludePatterns = new PatternList();
            for (String pattern : this.contentExcludePatterns) {
                this.compiledContentExcludePatterns.add((Object)CommonUtils.compilePattern((String)pattern));
            }
        }
        if (AbapThirdPartyPathsSynchronizer.isAbapThirdPartyPathsFile(language, uniformPath, content)) {
            return false;
        }
        return this.compiledContentExcludePatterns.findsAnyIn(content);
    }

    public boolean isFileTooLarge(ELanguage language, byte[] content, String uniformPath) {
        if (this.maximumBytesPerFile < 0L) {
            this.maximumBytesPerFile = StringUtils.isEmpty((String)this.maximumFileSizeInput) ? Long.MAX_VALUE : FileSystemUtils.parseDataSize((String)this.maximumFileSizeInput);
        }
        if (AbapThirdPartyPathsSynchronizer.isAbapThirdPartyPathsFile(language, uniformPath, content)) {
            return false;
        }
        if ((long)content.length > this.maximumBytesPerFile) {
            LOGGER.warn("Excluding file because of file size. " + uniformPath + " size in bytes: " + content.length + " > " + this.maximumBytesPerFile);
            return true;
        }
        return false;
    }
}

