/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.artifact_store.revision_interpretation.BranchNameIndependentRevisionInterpretationBase;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ERevisionType;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;

final class ConnectorIndependentRevisionInterpretation
extends BranchNameIndependentRevisionInterpretationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RepositoryRevisionIndex revisionIndex;

    public ConnectorIndependentRevisionInterpretation(RepositoryRevisionIndex revisionIndex) {
        this.revisionIndex = revisionIndex;
    }

    @Override
    protected Optional<CommitDescriptor> interpretRevisionBranchNameIndependent(String revision) throws RepositoryException {
        LOGGER.traceEntry("Interpreting revision {}", new Object[]{revision});
        try {
            return (Optional)LOGGER.traceExit("Found commit {} for revision %s".formatted(revision), this.revisionIndex.getFirstKnownRepositoryCommit(revision));
        }
        catch (StorageException e) {
            throw (RepositoryException)LOGGER.throwing(Level.TRACE, (Throwable)new RepositoryException((Throwable)e));
        }
    }

    @Override
    public boolean mayRequireReschedule() {
        return true;
    }

    @Override
    public ERevisionType getRevisionType() {
        return ERevisionType.MULTIPLE;
    }
}

