/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.repository.artifact_store.revision_interpretation.BranchNameDependentRevisionInterpretationBase;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ERevisionType;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jspecify.annotations.NonNull;

final class ConnectorRevisionInterpretation
extends BranchNameDependentRevisionInterpretationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SupplierWithException<ICommitTree, RepositoryException> foreignCommitTree;

    public ConnectorRevisionInterpretation(SupplierWithException<ICommitTree, RepositoryException> foreignCommitTree) {
        this.foreignCommitTree = foreignCommitTree;
    }

    @Override
    protected Optional<CommitDescriptor> interpretRevisionWithBranchName(String revision, @NonNull String branchName) throws RepositoryException {
        ICommitTreeNode node = ((ICommitTree)this.foreignCommitTree.get()).getNodeByRevision(new CommitTreeRevision(revision, branchName));
        if (node == null) {
            LOGGER.debug("Revision {} not contained in foreign commit tree. Can happen if the revision is outside the analysis scope of the connector or was labeled to a branch other than {}.", (Object)revision, (Object)branchName);
            return Optional.empty();
        }
        return ConnectorRevisionInterpretation.getCommitForAdjustedTimestamp(branchName, node);
    }

    public static Optional<CommitDescriptor> getCommitForAdjustedTimestamp(String branchName, ICommitTreeNode node) {
        if (node.getAdjustedTimestamp().isEmpty()) {
            LOGGER.warn("Skipping revision interpretation of node {} in foreign connector which isn't adjusted yet.", (Object)node);
            return Optional.empty();
        }
        return Optional.of(new CommitDescriptor(branchName, node.getAdjustedTimestamp().getAsLong()));
    }

    @Override
    public ERevisionType getRevisionType() {
        return ERevisionType.OTHER;
    }
}

