/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.options.RepositoryCloneOption;
import com.teamscale.index.repository.base.AccountBasedRepositoryConnectorBase;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.git.GitCredentials;
import com.teamscale.index.repository.git.GitIndices;
import com.teamscale.index.repository.git.GitPrivateKeyOption;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.GitRepositoryConnectorParameterStep;
import com.teamscale.index.repository.git.GitUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Optional;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.index.shared.EGitProtocol;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class GitRepositoryConnector
extends AccountBasedRepositoryConnectorBase<GitRepositoryConnection> {
    @StepParameterObject
    protected GitRepositoryConnectorParameterStep gitParameters = new GitRepositoryConnectorParameterStep();

    public GitRepositoryConnector() {
    }

    public GitRepositoryConnector(GitRepositoryConnectorDescriptor gitConnectorDescriptor, GitIndices gitConnectionIndices, IBranchingLayer branchPointerIndexBranchingLayer) throws ConnectorValidationException {
        this.baseParameters = RepositoryConnectorBaseParameterStep.builder(gitConnectorDescriptor.getConnectorIdentifier(), gitConnectorDescriptor.getDefaultBranchName()).withCodePattern(new IncludeExcludeAntPatternSupport(gitConnectorDescriptor.codeIncludePatterns, gitConnectorDescriptor.codeExcludePatterns)).withTestCodePattern(new IncludeExcludeAntPatternSupport(gitConnectorDescriptor.testCodeIncludePatterns, gitConnectorDescriptor.testCodeIncludePatterns)).withBranchPattern(gitConnectorDescriptor.branchIncludePatterns, gitConnectorDescriptor.branchExcludePatterns).withBranchingEnabled(gitConnectorDescriptor.branchingEnabled).withPathSuffix(gitConnectorDescriptor.getPathSuffix()).withPollingIntervalSeconds(gitConnectorDescriptor.pollingIntervalSeconds).build();
        this.accountIdentifier = gitConnectorDescriptor.getAccountIdentifier();
        this.gitParameters = GitRepositoryConnectorParameterStep.builder(gitConnectionIndices, branchPointerIndexBranchingLayer).withIsIncludeSubModules(gitConnectorDescriptor.isIncludeSubModules()).withSshKeyIdentifier(gitConnectorDescriptor.getPrivateKeyId()).withSubModuleRecursionDepth(gitConnectorDescriptor.getSubModuleRecursionDepth()).withImportantBranchPatterns(gitConnectorDescriptor.importantBranchPatterns).withUserRequestedRefSpecs(gitConnectorDescriptor.getAdditionalRefSpecMappings().keySet()).build();
    }

    @Override
    public GitRepositoryConnection createConnection(IProfilingMonitor profilingMonitor, ICancelable cancelable, IParallelTaskExecutor parallelTaskExecutor) throws RepositoryException {
        ExternalCredentials externalCredentials = this.getExternalCredentials();
        try {
            GitCredentials gitCredentials = new GitCredentials(externalCredentials, GitRepositoryConnector.adjustGitUrlAndConvertToUri(externalCredentials.uri, this.getBaseParameters().getPathSuffix()), this.getPrivateKeyOption());
            return new GitRepositoryConnection(this.getBaseParameters(), this.gitParameters, gitCredentials, cancelable);
        }
        catch (ProjectConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected @Nullable GitPrivateKeyOption getPrivateKeyOption() throws RepositoryException {
        return GitRepositoryConnector.getPrivateKeyOption(this.gitParameters.getServerOptionIndex(), this.gitParameters.getSshKeyIdentifier(), this.accountIdentifier).orElse(null);
    }

    public static Optional<GitPrivateKeyOption> getPrivateKeyOption(ServerOptionIndex serverOptionIndex, String sshKeyIdentifier, String accountIdentifier) throws RepositoryException {
        if (StringUtils.isEmpty((String)sshKeyIdentifier)) {
            return Optional.empty();
        }
        try {
            return Optional.of((GitPrivateKeyOption)ServerOptionRegistry.getInstance().getServerMultiOption("git.privatekey", sshKeyIdentifier, GitPrivateKeyOption.class, serverOptionIndex));
        }
        catch (StorageException e) {
            throw new RepositoryException("No SSH Key setting found with the id '" + accountIdentifier + "'. Were they deleted?", (Throwable)e);
        }
    }

    protected Path getRepositoryCloneDirectory() throws RepositoryException {
        try {
            return RepositoryCloneOption.getRepositoryCloneDirectory((ServerOptionIndex)this.gitParameters.getServerOptionIndex());
        }
        catch (StorageException e) {
            throw new RepositoryException("No working directory configured. Please configure one under Admin > Settings", (Throwable)e);
        }
    }

    public static URI adjustGitUrlAndConvertToUri(String url) throws ProjectConfigurationException {
        return GitRepositoryConnector.adjustGitUrlAndConvertToUri(url, "");
    }

    public static URI adjustGitUrlAndConvertToUri(String url, String pathSuffix) throws ProjectConfigurationException {
        String combinedUrl = GitRepositoryConnector.concatenateUriAndPathSuffix(url, pathSuffix);
        String newUrl = GitUtils.rewriteGitAtUrl(combinedUrl);
        Optional protocol = EGitProtocol.fromUri((String)newUrl);
        try {
            if (protocol.isEmpty() && new File(newUrl).exists()) {
                return UrlUtils.parseUri((String)(EGitProtocol.FILE.getUrlPrefix() + newUrl));
            }
            return UrlUtils.parseUri((String)newUrl);
        }
        catch (URISyntaxException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
    }
}

