/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.metric.MetricBadgesConfiguration;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerChangeRetriever;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerContentUpdater;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerMergeRequestAnnotationTrigger;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerMergeRequestSynchronizer;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryIdentifier;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerUtils;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerWebhookEventIndex;
import com.teamscale.index.repository.git.bitbucket.server.client.BitbucketServerClient;
import com.teamscale.index.repository.git.bitbucket.server.model.web_hooks.BitbucketServerWebHook;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.common.WebHookBasedGitRepositoryConnectorDescriptorBase;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.version.Version;
import org.jetbrains.annotations.VisibleForTesting;

@ConnectorDescriptor
public class BitbucketServerRepositoryConnectorDescriptor
extends WebHookBasedGitRepositoryConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PERSONAL_REPOSITORY_PROJECT_KEY_PREFIX = "~";
    public static final long MERGE_REQUEST_UPDATE_DELAY_SECONDS = Long.getLong("com.teamscale.mergerequest.bitbucket.server.update-delay-seconds", 5L);
    public static final String ENABLE_REVIEW_OPTION_NAME = "Enable pull request review";
    public static final boolean ENABLE_REVIEW_DEFAULT = false;
    public static final String INLINE_COMMENTS_VIA_PULL_REQUEST_COMMENTS = "Add Detailed Line Comments For Findings and Test Gaps as Pull Request Comments";
    public static final boolean INLINE_COMMENTS_VIA_PULL_REQUEST_COMMENTS_DEFAULT = false;
    public static final String INLINE_COMMENTS_VIA_CODE_INSIGHTS_REPORT = "Add Detailed Line Comments For Findings and Test Gaps as Code Insights Report";
    public static final boolean INLINE_COMMENTS_VIA_CODE_INSIGHTS_REPORT_DEFAULT = true;
    public static final String ADD_BADGES_AS_PULL_REQUEST_COMMENT_OPTION_NAME = "Add badges in a pull request comment";
    public static final boolean ADD_BADGES_AS_PULL_REQUEST_COMMENT_DEFAULT = false;
    private static final int DEFAULT_BUILD_POLLING_INTERVAL_SECONDS = 600;
    private static final String[] EXPECTED_WEB_HOOK_EVENTS = new String[]{"repo:refs_changed", "pr:from_ref_updated", "pr:opened", "pr:modified", "pr:merged", "pr:declined", "pr:deleted"};
    @ConfigExposed(name="Enable Voting for Findings", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will vote on the pull request by updating the build status. Please note that if this option is enabled and there are findings added to the pull request, the build status will be updated to 'FAILED' and the pull request might not be merged depending on the set Bitbucket merge checks.")
    protected boolean findingsVotingEnabled = true;
    @ConfigExposed(name="Enable pull request review", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will vote on the pull request by posting a review, in addition to adding a build to the pull request. By enabling this option, Teamscale will be added as a reviewer to the pull request. Requires at least one voting option (voting for findings, test gaps or test coverage) to be enabled as well.")
    protected boolean enablePullRequestReview = false;
    @ConfigExposed(name="Add Detailed Line Comments For Findings and Test Gaps as Pull Request Comments", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will add inline comments for findings or test gaps as actual comments on the pull request.")
    protected boolean enableInlineCommentsAsPrComments = false;
    @ConfigExposed(name="Add Detailed Line Comments For Findings and Test Gaps as Code Insights Report", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will use the Bitbucket Code Insights reports to add comments for findings.")
    protected boolean enableCodeInsightsReport = true;
    @ConfigExposed(name="Enable Detailed Line Comments for Findings", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, a Teamscale vote will carry a detailed comment for each generated finding that is annotated to the relevant line in the reviewed file.", dependentOptions={"Add Detailed Line Comments For Findings and Test Gaps as Pull Request Comments", "Add Detailed Line Comments For Findings and Test Gaps as Code Insights Report", "Aggregate Findings in Single Comment"})
    protected boolean findingsDetailedLineCommentsEnabled = true;
    @ConfigExposed(name="Add Detailed Line Comments for Test Gaps", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will add a detailed comment for each method or function that is untested. Other constraints may have to be met before comments are added, such as pending build results or uploads.", dependentOptions={"Add Detailed Line Comments For Findings and Test Gaps as Pull Request Comments", "Add Detailed Line Comments For Findings and Test Gaps as Code Insights Report", "Aggregate Findings in Single Comment"})
    protected boolean testGapLineCommentsEnabled = false;
    @ConfigExposed(name="Add badges in a pull request comment", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will add all enabled badges (e.g. Findings Badge, Test Gap Badge, etc) in a pull request comment instead of adding the badges in the pull request description.")
    protected boolean addBadgesAsPullRequestComment = false;
    @ConfigExposed(name="Badges for Metrics", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="Metrics which should be tracked in merge requests via badges.")
    protected MetricBadgesConfiguration metricThresholdBadges = new MetricBadgesConfiguration();
    @ConfigExposed(name="Badges for Metric Groups", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="Metrics which should be included in a summarized badge for their group in merge requests.")
    protected MetricBadgesConfiguration metricThresholdGroupBadges = new MetricBadgesConfiguration();
    private static final String LEGACY_BITBUCKET_HOOK_END_POINT = "bitbucket-server-hook";
    public static final String BITBUCKET_HOOK_END_POINT = "api/bitbucket-server/web-hook";

    public BitbucketServerRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.BITBUCKET_SERVER, LOGGER);
        this.autoExpose();
    }

    @VisibleForTesting
    BitbucketServerRepositoryConnectorDescriptor(String repositoryName) {
        this();
        this.repositoryName = repositoryName;
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(BitbucketServerWebhookEventIndex.class);
    }

    protected void initInternal() {
        super.initInternal();
        this.repositoryName = this.repositoryName.toLowerCase();
    }

    private BitbucketServerClient getClient() throws ConnectorValidationException {
        ExternalCredentials credentials = this.resolveExternalCredentials();
        return new BitbucketServerClient(super.getRepositoryUri().toString(), credentials.username, credentials.password, LOGGER);
    }

    private String getRepositoryUriSubPath() {
        BitbucketServerRepositoryIdentifier repositoryIdentifier = BitbucketServerRepositoryIdentifier.fromRepositoryName(this.repositoryName);
        return repositoryIdentifier.getOwner().toUpperCase() + "/repos/" + repositoryIdentifier.getRepo();
    }

    @Override
    protected String getCommitLinkTemplate() throws ConnectorValidationException {
        return BitbucketServerRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(super.getRepositoryUri().toString(), "projects", this.getRepositoryUriSubPath(), "commits/{commitId}");
    }

    @Override
    protected String getCommitInMergeRequestLinkTemplate() throws ConnectorValidationException {
        BitbucketServerRepositoryIdentifier repositoryIdentifier = BitbucketServerRepositoryIdentifier.fromRepositoryName(this.repositoryName);
        String commitInPullRequestSuffix = "pull-requests/{mergeRequestId}/commits/{commitId}";
        if (BitbucketServerRepositoryConnectorDescriptor.isPersonalRepository(repositoryIdentifier)) {
            return BitbucketServerRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(super.getRepositoryUri().toString(), "users", BitbucketServerRepositoryConnectorDescriptor.extractUsernameFromPersonalRepository(repositoryIdentifier), "repos", repositoryIdentifier.getRepo(), commitInPullRequestSuffix);
        }
        return BitbucketServerRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(super.getRepositoryUri().toString(), "projects", this.getRepositoryUriSubPath(), commitInPullRequestSuffix);
    }

    private static boolean isPersonalRepository(PlatformRepositoryIdentifier repositoryIdentifier) {
        return repositoryIdentifier.getOwner().startsWith(PERSONAL_REPOSITORY_PROJECT_KEY_PREFIX);
    }

    private static String extractUsernameFromPersonalRepository(PlatformRepositoryIdentifier repositoryIdentifier) {
        return StringUtils.stripPrefix((String)repositoryIdentifier.getOwner(), (String)PERSONAL_REPOSITORY_PROJECT_KEY_PREFIX);
    }

    @Override
    public URI getRepositoryUri() throws ConnectorValidationException {
        try {
            return this.parseUri(BitbucketServerUtils.getHttpCloneUrlFromResponse(this.getClient().getBitbucketRepository(PlatformRepositoryIdentifier.fromRepositoryName(this.repositoryName))));
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    private void checkServerVersion() throws ConnectorValidationException {
        try {
            String currentVersion = this.getClient().getServerVersion();
            Version minimumVersion = new Version(7, 0);
            if (BitbucketServerRepositoryConnectorDescriptor.isOutdatedServerVersion(minimumVersion, currentVersion)) {
                throw new ConnectorValidationException("Minimum required Bitbucket Server version is " + String.valueOf(minimumVersion) + ". Please update your server from version " + currentVersion + " to be able to use this connector.");
            }
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    @Override
    protected void ensureHookIsConfigured(ServerOptionIndex serverOptionIndex) throws StorageException, ServiceCallException, ConnectorValidationException {
        String legacyUrl = BaseUrlOption.getBaseUrl((ServerOptionIndex)serverOptionIndex) + LEGACY_BITBUCKET_HOOK_END_POINT;
        String expectedUrl = BaseUrlOption.getBaseUrl((ServerOptionIndex)serverOptionIndex) + BITBUCKET_HOOK_END_POINT;
        BitbucketServerRepositoryIdentifier repositoryIdentifier = BitbucketServerRepositoryIdentifier.fromRepositoryName(this.repositoryName);
        BitbucketServerClient client = this.getClient();
        List<BitbucketServerWebHook> webHooks = client.getRepositoryWebHooks(repositoryIdentifier);
        Optional<BitbucketServerWebHook> legacyMatchingHook = this.findLegacyWebhook(webHooks, legacyUrl);
        if (legacyMatchingHook.isPresent()) {
            client.updateRepositoryWebHook(repositoryIdentifier, legacyMatchingHook.get().id(), expectedUrl, EXPECTED_WEB_HOOK_EVENTS);
            return;
        }
        if (BitbucketServerRepositoryConnectorDescriptor.repositoryHasMatchingWebhook(webHooks, expectedUrl)) {
            return;
        }
        Optional<BitbucketServerWebHook> outdatedHook = this.findOutdatedWebhook(webHooks, expectedUrl);
        if (outdatedHook.isPresent()) {
            client.updateRepositoryWebHook(repositoryIdentifier, outdatedHook.get().id(), expectedUrl, EXPECTED_WEB_HOOK_EVENTS);
            return;
        }
        client.createRepositoryWebHook(repositoryIdentifier, expectedUrl, EXPECTED_WEB_HOOK_EVENTS);
    }

    private Optional<BitbucketServerWebHook> findLegacyWebhook(List<BitbucketServerWebHook> webHooks, String legacyUrl) {
        return webHooks.stream().filter(hook -> hook.active() && legacyUrl.equals(hook.url()) && CollectionUtils.asHashSet((Object[])hook.events()).containsAll(Arrays.asList(EXPECTED_WEB_HOOK_EVENTS))).findFirst();
    }

    private static boolean repositoryHasMatchingWebhook(List<BitbucketServerWebHook> webHooks, String ... expectedUrl) {
        HashSet<String> validUrls = new HashSet<String>(Arrays.asList(expectedUrl));
        return webHooks.stream().anyMatch(hook -> hook.active() && validUrls.contains(hook.url()) && CollectionUtils.asHashSet((Object[])hook.events()).containsAll(Arrays.asList(EXPECTED_WEB_HOOK_EVENTS)));
    }

    private Optional<BitbucketServerWebHook> findOutdatedWebhook(List<BitbucketServerWebHook> webHooks, String expectedUrl) {
        return webHooks.stream().filter(hook -> {
            Set missingEvents = CollectionUtils.subtract(Arrays.asList(EXPECTED_WEB_HOOK_EVENTS), Arrays.asList(hook.events()));
            return hook.active() && expectedUrl.equals(hook.url()) && missingEvents.size() == 1 && missingEvents.contains("pr:from_ref_updated");
        }).findFirst();
    }

    @Override
    public Class<? extends CommitVotingTriggerBase<?>> getMergeRequestAnnotationTriggerClass() {
        return BitbucketServerMergeRequestAnnotationTrigger.class;
    }

    @Override
    public Class<? extends AnalysisStepBase> getPullRequestSynchronizerClass() {
        return BitbucketServerMergeRequestSynchronizer.class;
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return BitbucketServerChangeRetriever.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return BitbucketServerContentUpdater.class;
    }

    @Override
    protected boolean enableIgnoreWebhooksFromUserOption() {
        return true;
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        GitRepositoryManagementConnectorDescriptorBase.splitRepositoryName(this.repositoryName, ConnectorValidationException::new);
        this.checkServerVersion();
        this.validateInlineCommentsOption();
        this.validateCodeInsightSupport();
    }

    private void validateInlineCommentsOption() throws ConnectorValidationException {
        boolean lineCommentsEnabled;
        boolean bl = lineCommentsEnabled = this.findingsIntegrationEnabled && this.findingsDetailedLineCommentsEnabled;
        if (lineCommentsEnabled && !this.enableInlineCommentsAsPrComments && !this.enableCodeInsightsReport) {
            throw new ConnectorValidationException("Option 'Enable Detailed Line Comments for Findings' is enabled but neither 'Add Detailed Line Comments For Findings and Test Gaps as Pull Request Comments' nor 'Add Detailed Line Comments For Findings and Test Gaps as Code Insights Report' is enabled. Please choose at least one.");
        }
    }

    private void validateCodeInsightSupport() throws ConnectorValidationException {
        if (!this.enableCodeInsightsReport) {
            return;
        }
        try {
            Version minimumVersionForCodeInsightsReports = new Version(5, 15);
            BitbucketServerClient client = this.getClient();
            String bitbucketServerVersion = client.getServerVersion();
            if (BitbucketServerRepositoryConnectorDescriptor.isOutdatedServerVersion(minimumVersionForCodeInsightsReports, bitbucketServerVersion)) {
                throw new ConnectorValidationException("The configured Bitbucket Server installation with version '" + bitbucketServerVersion + "' is not compatible with code insights reports. Please disable the option 'Add Detailed Line Comments For Findings and Test Gaps as Code Insights Report'.");
            }
        }
        catch (ServiceCallException sce) {
            throw new ConnectorValidationException("Could not fetch Bitbucket Server version to validate use of of code insights reports. If this issue persists, consider disabling the option 'Add Detailed Line Comments For Findings and Test Gaps as Code Insights Report' in favor of 'Add Detailed Line Comments For Findings and Test Gaps as Pull Request Comments'.", (Throwable)sce);
        }
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.setCommonParameters(triggerBuilder, triggerCreator);
        triggerBuilder.setTriggerParameter(INLINE_COMMENTS_VIA_PULL_REQUEST_COMMENTS, this.enableInlineCommentsAsPrComments);
        triggerBuilder.setTriggerParameter(INLINE_COMMENTS_VIA_CODE_INSIGHTS_REPORT, this.enableCodeInsightsReport);
    }

    @Override
    protected boolean requiresBuildCompleteness() {
        return true;
    }

    @Override
    protected boolean supportsTestRelatedVoting() {
        return true;
    }

    @Override
    public int getDefaultBuildPollingInterval() {
        return 600;
    }
}

