/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.rest.client.authentication.ERestClientAuthenticationMode;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.repository.git.GitIndices;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.gerrit.GerritRepositoryConnection;
import com.teamscale.index.repository.git.gerrit.GerritRepositoryConnectorDescriptor;
import java.net.URI;
import java.net.URISyntaxException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.lib.commons.string.StringUtils;

public class GerritRepositoryConnector
extends GitRepositoryConnector {
    public static final String MINIMUM_CREATION_DATE_OR_REVISION_PARAMETER = "minimum-creation-date-and-revision";
    public static final String GERRIT_PROJECT_PARAMETER = "gerrit-project";
    public static final String FETCH_MERGED_CHANGES = "fetch-merged-changes";
    public static final String READ_TIMEOUT_PARAMETER = "read-timeout";
    public static final String AUTHENTICATION_MODE_PARAMETER = "authentication-mode";
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="merge-requests")
    protected MergeRequestIndex mergeRequestIndex;
    @StepParameter(value="gerrit-project")
    private String projectName;
    @StepParameter(value="minimum-creation-date-and-revision", optional=true)
    private String minimumCreationDateOrRevision;
    @StepParameter(value="fetch-merged-changes", optional=true)
    private boolean fetchMergedChanges;
    @StepParameter(value="read-timeout", optional=true)
    private int readTimeoutSeconds = 360;
    @StepParameter(value="authentication-mode", optional=true)
    private ERestClientAuthenticationMode authenticationMode = ERestClientAuthenticationMode.BASIC;

    public GerritRepositoryConnector() {
    }

    public GerritRepositoryConnector(GerritRepositoryConnectorDescriptor connectorDescriptor, GitIndices gitIndices, IBranchingLayer branchPointerIndexBranchingLayer) throws ConnectorValidationException {
        super(connectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
    }

    @Override
    public GerritRepositoryConnection createConnection(IProfilingMonitor profilingMonitor, ICancelable cancelable, IParallelTaskExecutor parallelTaskExecutor) throws RepositoryException {
        ExternalCredentials externalCredentials = this.getExternalCredentials();
        if (StringUtils.isEmpty((String)this.projectName)) {
            throw new RepositoryException("No project given, cannot create Gerrit connection!");
        }
        try {
            return new GerritRepositoryConnection(this.getBaseParameters(), this.gitParameters, GerritRepositoryConnector.getRepositoryUri(externalCredentials, this.getBaseParameters().getPathSuffix()), externalCredentials.username, externalCredentials.password, this.projectName, this.mergeRequestIndex, this.getPrivateKeyOption(), this.authenticationMode, this.readTimeoutSeconds, this.minimumCreationDateOrRevision, this.fetchMergedChanges, cancelable);
        }
        catch (URISyntaxException e) {
            throw new RepositoryException("Could not create Git repository connection", (Throwable)e);
        }
    }

    private static URI getRepositoryUri(ExternalCredentials externalCredentials, String pathSuffix) throws RepositoryException {
        try {
            URI baseUrl = GitRepositoryConnector.adjustGitUrlAndConvertToUri(externalCredentials.uri, pathSuffix);
            String projectUrl = StringUtils.ensureEndsWith((String)baseUrl.toString(), (String)"/");
            return new URI(projectUrl);
        }
        catch (ProjectConfigurationException | URISyntaxException e) {
            throw new RepositoryException(e);
        }
    }
}

