/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.index.merge_request.MergeRequestSynchronizerBase;
import com.teamscale.index.repository.RepositoryChangeRetrieverBase;
import com.teamscale.index.repository.base.IncludeExcludeStepParameter;
import com.teamscale.index.repository.git.github.GitHubChangeRetriever;
import com.teamscale.index.repository.git.github.GitHubClientHelper;
import com.teamscale.index.repository.git.github.GitHubMergeRequestProvider;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.persistence.store.StorageException;

@AnalysisStep
public class GitHubMergeRequestSynchronizer
extends MergeRequestSynchronizerBase<GitHubMergeRequestProvider, GitHubPullRequest> {
    private static final Logger LOGGER = LogManager.getLogger();
    @StepParameter(value="repository-name")
    private String repositoryName;
    @StepParameterObject
    private final GitHubClientHelper<ServiceCallException> clientHelper = new GitHubClientHelper<ServiceCallException>(ServiceCallException::new, LOGGER);
    @StepParameterObject(namePrefix="build-")
    private final IncludeExcludeStepParameter<IncludeExcludeRegexSupport> buildPatternSupport = new IncludeExcludeStepParameter<IncludeExcludeRegexSupport>(IncludeExcludeRegexSupport::new);
    @StepParameter(value="context-identifier")
    private String contextIdentifier;

    @Override
    protected GitHubMergeRequestProvider createMergeRequestProvider() throws StorageException, ServiceCallException {
        GitHubPullRequestClient client = this.clientHelper.createGitHubPullRequestClient();
        return new GitHubMergeRequestProvider(this.repositoryName, client, this.buildPatternSupport.get(), this.contextIdentifier);
    }

    @Override
    protected String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    protected Class<? extends RepositoryChangeRetrieverBase> getChangeRetrieverClass() {
        return GitHubChangeRetriever.class;
    }
}

