/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github.data;

import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.data.GitHubCommitStatus;
import org.apache.logging.log4j.Logger;

public record GitHubBuildJob(String name, String status) {
    public GitHubBuildJob(GitHubCommitStatus commitStatus) {
        this(commitStatus.context(), commitStatus.state());
    }

    public static GitHubBuildJob fromCheckRun(CheckRun checkRun, Logger logger) {
        return new GitHubBuildJob(checkRun.name(), GitHubBuildJob.adjustStatus(checkRun, logger));
    }

    private static String adjustStatus(CheckRun checkRun, Logger logger) {
        if (checkRun.conclusion() != null && checkRun.status() != CheckRun.Status.COMPLETED) {
            logger.error("Found inconsistent status for check run '{}' (id: {}): The status indicates that it is not completed ({}) but it has a conclusion ({}). Treating this check run as completed.", (Object)checkRun.name(), (Object)checkRun.id(), (Object)checkRun.status().name(), (Object)checkRun.conclusion().name());
            return CheckRun.Status.COMPLETED.name().toLowerCase();
        }
        return checkRun.status().name().toLowerCase();
    }
}

