/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.labeling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.CommitGraphNode;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jetbrains.annotations.VisibleForTesting;

public class TestCommitGraphNode
extends CommitGraphNode {
    @JsonProperty(value="commitMessage")
    private String commitMessage;
    @JsonProperty(value="commitTimestamp")
    private long commitTimestamp;
    @JsonProperty(value="parentIds")
    private final List<String> parentIds = new ArrayList<String>();

    @JsonCreator
    public TestCommitGraphNode(@JsonProperty(value="name") String name, @JsonProperty(value="commitMessage") String commitMessage, @JsonProperty(value="commitTimestamp") long commitTimestamp) {
        super(name);
        this.commitMessage = commitMessage;
        this.commitTimestamp = commitTimestamp;
    }

    @Override
    public long getCommitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public void setCommitTimestamp(long commitTimestamp) {
        this.commitTimestamp = commitTimestamp;
    }

    public void setSuccessors(List<CommitGraphNode> successors) {
        this.successors = successors;
    }

    @Override
    public RevCommit getCommit() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ZonedDateTime getAuthorTime() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.commitTimestamp), ZoneId.systemDefault());
    }

    @Override
    public AnyObjectId getCommitId() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<String> getParentIds() {
        return this.parentIds;
    }

    public TestCommitGraphNode addParent(TestCommitGraphNode parent) {
        this.parents.add(parent);
        this.parentIds.add(parent.getName());
        parent.successors.add(this);
        return this;
    }

    @VisibleForTesting
    void resolveParentNodes(Map<String, CommitGraphNode> commitToNode) {
        for (String parentId : this.parentIds) {
            CommitGraphNode parentNode = commitToNode.get(parentId);
            this.parents.add(parentNode);
            parentNode.addSuccessor(this);
        }
    }

    @Override
    public void resolve(Map<String, CommitGraphNode> nodesByName) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String toString() {
        return "TestCommitGraphNode [name=" + this.getName() + ", commitMessage=" + this.commitMessage + ", commitTimestamp=" + this.commitTimestamp + ", branchName=" + this.branchName + ", parents=" + String.valueOf(CollectionUtils.map((Collection)this.parents, CommitGraphNode::getName)) + ", successors=" + String.valueOf(CollectionUtils.map((Collection)this.successors, CommitGraphNode::getName)) + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TestCommitGraphNode node = (TestCommitGraphNode)o;
        return this.commitTimestamp == node.commitTimestamp && Objects.equals(this.commitMessage, node.commitMessage) && Objects.equals(this.parentIds, node.parentIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.commitMessage, this.commitTimestamp, this.parentIds);
    }
}

