/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.sap.abapsystem.AbapProjectUtils;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.rfc.AbapTiaRfcExecuter;
import com.teamscale.index.repository.sap.abapsystem.rfc.SapSystemCommunicationException;
import com.teamscale.index.testimpact.ManualSapTestInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class SapTestwiseCoverageCommunicator {
    public static final String MESSAGE_COVERAGE_REPORT_NOT_GENERATED_YET = "Coverage report not yet generated.";
    private final String sapUser;
    private final String sapConfigurationId;
    private final ServerOptionIndex serverOptionIndex;
    private final AbapSystemDescription abapSystemDescription;
    private Collection<String> includedNamespaces;
    private Collection<String> excludedNamespaces;

    public SapTestwiseCoverageCommunicator(IProjectId projectId, String sapUser, IndexLayer indexLayer) throws StorageException {
        this.sapUser = sapUser;
        ExternalCredentialsIndex externalCredentialsIndex = (ExternalCredentialsIndex)indexLayer.openGlobalIndex(ExternalCredentialsIndex.class);
        this.serverOptionIndex = (ServerOptionIndex)indexLayer.openGlobalIndex(ServerOptionIndex.class);
        MetaIndex metaIndex = indexLayer.openMetaIndex(projectId);
        Map<String, IncludeExcludeAntPatternSupport> abapSystemConfiguration = AbapProjectUtils.resolveSapConfigurationIdsWithNamespacesForProject(externalCredentialsIndex, metaIndex);
        CCSMAssert.isTrue((abapSystemConfiguration.size() == 1 ? 1 : 0) != 0, (String)("SAP configuration ID is not unique for project '" + String.valueOf(projectId) + "' (has " + abapSystemConfiguration.size() + " IDs)."));
        Map.Entry<String, IncludeExcludeAntPatternSupport> sapConfig = abapSystemConfiguration.entrySet().iterator().next();
        this.sapConfigurationId = sapConfig.getKey();
        this.abapSystemDescription = AbapSystemDescription.getInstanceFromOptionIndex(this.sapConfigurationId, this.serverOptionIndex);
        CCSMAssert.isNotNull((Object)this.abapSystemDescription, (String)("No SAP connection configuration found for id '" + this.sapConfigurationId + "'"));
        this.inferIncludedNamespaces(sapConfig);
    }

    private void inferIncludedNamespaces(Map.Entry<String, IncludeExcludeAntPatternSupport> sapConfig) {
        UnmodifiableList namespacesInAbapGitConnector = sapConfig.getValue().getIncludePatterns();
        this.excludedNamespaces = sapConfig.getValue().getExcludePatterns();
        Set<String> namespacesInAbapSystemConnector = Arrays.asList(this.abapSystemDescription.addtionalCustomNamespaces.split(",")).stream().map(String::trim).collect(Collectors.toSet());
        this.includedNamespaces = SapTestwiseCoverageCommunicator.preferNamespaceDefinedInProjectConfiguration((Collection<String>)namespacesInAbapGitConnector, namespacesInAbapSystemConnector);
        if (this.abapSystemDescription.includeDefaultCustomNamespace) {
            this.includedNamespaces.add("Y");
            this.includedNamespaces.add("Z");
        }
    }

    public String startCoverageRecordingForUser() throws ConQATException {
        return this.retrieveAbapTiaAnswer("START_REC", (Map<String, String>)CollectionUtils.emptyMap());
    }

    public String stopCoverageRecordingForUser(ManualSapTestInfo testInfo, boolean skipReport) throws ConQATException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("I_TEST_KEY", testInfo.makeKey());
        parameters.put("I_DURATION", String.format("%f", testInfo.getDuration()));
        parameters.put("I_RESULT", Optional.ofNullable(testInfo.getResult()).orElse(ETestExecutionResult.ERROR).toString());
        parameters.put("I_MESSAGE", StringEscapeUtils.escapeJson((String)Optional.ofNullable(testInfo.getOutput()).orElse("")));
        parameters.put("I_TEST_NAME", StringEscapeUtils.escapeJson((String)testInfo.getName()));
        parameters.put("I_INCLUDED_NAMESPACES", SapTestwiseCoverageCommunicator.formatNamespacesForRfcCall(this.includedNamespaces));
        parameters.put("I_EXCLUDED_NAMESPACES", SapTestwiseCoverageCommunicator.formatNamespacesForRfcCall(this.excludedNamespaces));
        if (skipReport) {
            parameters.put("I_SKIP_REPORT", Character.toString('X'));
        } else {
            parameters.put("I_SKIP_REPORT", Character.toString(' '));
        }
        return this.retrieveAbapTiaAnswer("END_REC", parameters);
    }

    public Pair<String, String> getCoverageReportWithLog(String testKey) throws ConQATException {
        AbapTiaRfcExecuter tiaRfcExecuter = this.executeAbapTiaFunction("GET_REPORT", Collections.singletonMap("I_TEST_KEY", testKey));
        return new Pair((Object)tiaRfcExecuter.getReturnMessage(), (Object)tiaRfcExecuter.getStringExportParameter("E_LOG"));
    }

    private String retrieveAbapTiaAnswer(String functionPostfix, Map<String, String> parameters) throws ConQATException {
        return this.executeAbapTiaFunction(functionPostfix, parameters).getReturnMessage();
    }

    private AbapTiaRfcExecuter executeAbapTiaFunction(String functionPostfix, Map<String, String> parameters) throws ConQATException {
        try {
            AbapTiaRfcExecuter tiaRfcExecuter = new AbapTiaRfcExecuter(this.sapUser, functionPostfix, this.sapConfigurationId, this.abapSystemDescription, this.serverOptionIndex, parameters);
            tiaRfcExecuter.executeRfcFunction();
            return tiaRfcExecuter;
        }
        catch (SapSystemCommunicationException e) {
            throw new ConQATException("Remote function call on SAP server failed.", (Throwable)e);
        }
    }

    private static String formatNamespacesForRfcCall(Collection<String> namespaces) {
        return String.join((CharSequence)",", namespaces);
    }

    private static Collection<String> preferNamespaceDefinedInProjectConfiguration(Collection<String> namespacesInProjectConfig, Collection<String> namespacesInAbapConnector) {
        if (namespacesInProjectConfig.isEmpty()) {
            return namespacesInAbapConnector;
        }
        return namespacesInProjectConfig;
    }

    public Collection<String> getIncludedNamespaces() {
        return this.includedNamespaces;
    }

    public Collection<String> getExcludedNamespaces() {
        return this.excludedNamespaces;
    }
}

