/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.util;

import com.teamscale.index.requirements_tracing.tools.polarion.client.util.PolarionClientSessionHandlerInfo;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class PolarionClientSessionHandler
implements Handler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SESSION_NS = "http://ws.polarion.com/session";
    private static final String SESSION_LOCALPART = "sessionID";
    private PolarionClientSessionHandlerInfo info;

    public void destroy() {
    }

    public QName[] getHeaders() {
        return new QName[0];
    }

    public boolean handleFault(MessageContext messageContext) {
        return false;
    }

    public boolean handleRequest(MessageContext messageContext) {
        Long currentClientSession = this.info.getSessionId();
        if (currentClientSession == null) {
            return true;
        }
        Message msg = ((org.apache.axis.MessageContext)messageContext).getRequestMessage();
        if (msg == null) {
            return false;
        }
        try {
            SOAPEnvelope env = msg.getSOAPEnvelope();
            SOAPHeaderElement header = new SOAPHeaderElement(SESSION_NS, SESSION_LOCALPART, (Object)currentClientSession);
            env.addHeader(header);
            if (this.info.getSessionCookie() != null && !this.info.getSessionCookie().isEmpty()) {
                messageContext.setProperty("Cookie", (Object)this.info.getSessionCookie());
            }
            return true;
        }
        catch (AxisFault ex) {
            LOGGER.error("Error when adding headers to SOAP envelope.", (Throwable)ex);
            return false;
        }
    }

    public boolean handleResponse(MessageContext messageContext) {
        Message msg = ((org.apache.axis.MessageContext)messageContext).getResponseMessage();
        if (msg == null) {
            return false;
        }
        try {
            SOAPEnvelope env = msg.getSOAPEnvelope();
            SOAPHeaderElement header = env.getHeaderByName(SESSION_NS, SESSION_LOCALPART);
            if (header == null) {
                return false;
            }
            this.info.setSessionId((Long)header.getValueAsType(Constants.XSD_LONG));
            header.setProcessed(true);
            if (messageContext.getProperty("Cookie") != null) {
                this.info.setSessionCookie((String)messageContext.getProperty("Cookie"));
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("Error extracting headers from the Polarion server response.", (Throwable)ex);
            return false;
        }
    }

    public void init(HandlerInfo handlerInfo) {
        this.info = (PolarionClientSessionHandlerInfo)((Object)CCSMAssert.checkedCast((Object)handlerInfo, PolarionClientSessionHandlerInfo.class));
    }
}

