/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.triggers.azure_devops;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.tfs.TfsWorkItem;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.tfs.TfsWorkItemSynchronizerBase;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.requirements_tracing.tools.util.WorkItemUtils;
import com.teamscale.index.requirements_tracing.triggers.azure_devops.AzureDevOpsAdditionalLinkResolver;
import com.teamscale.index.requirements_tracing.triggers.azure_devops.AzureDevOpsTestStepsParser;
import com.teamscale.wia.ManualTestCase;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class AzureDevOpsSpecItemSynchronizer
extends TfsWorkItemSynchronizerBase<SpecItem> {
    static final String TEST_STEP_CUSTOM_FIELD_NAME = "Microsoft.VSTS.TCM.Steps";
    public static final String ITEM_TYPES_REPRESENTING_TEST_CASES_PARAMETER = "item-types-representing-test-cases";
    public static final String INCLUDED_WORK_ITEM_LINK_ROLES_PARAMETER = "included-work-item-link-roles";
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SpecItemHistoryIndex specItemHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, indexName="spec-items")
    private SpecItemIndex previousSpecItemIndex;
    @StepParameter(value="item-type", optional=true)
    private final PairList<String, String> itemTypes = new PairList();
    @StepParameter(value="item-types-representing-test-cases", optional=true)
    private final Set<String> itemTypesRepresentingTestCases = new HashSet<String>();
    @StepParameter(value="included-work-item-link-roles", optional=true)
    private final PairList<String, String> includedWorkItemLinkRoles = new PairList();
    private final Map<String, String> itemTypeToTypeAbbreviation = new HashMap<String, String>();

    @Override
    protected void init() throws BugTrackerException {
        super.init();
        this.buildWorkItemTypeToAbbreviationMap();
        this.ensureTestStepsAreLoadedIfRequired();
    }

    private void ensureTestStepsAreLoadedIfRequired() {
        if (!this.itemTypesRepresentingTestCases.isEmpty() && !this.customFields.getFirstList().contains((Object)TEST_STEP_CUSTOM_FIELD_NAME)) {
            this.customFields.add((Object)TEST_STEP_CUSTOM_FIELD_NAME, (Object)false);
        }
    }

    public SpecItemHistoryIndex getIssueHistoryIndex() {
        return this.specItemHistoryIndex;
    }

    @Override
    protected IssueIndexBase<SpecItem> getWorkItemIndex() {
        return this.previousSpecItemIndex;
    }

    @Override
    protected PairList<SpecItem, String> withAdditionalUpdatedItems(long lastScanTimestamp, PairList<SpecItem, String> issueUpdates) throws BugTrackerException, StorageException {
        AzureDevOpsAdditionalLinkResolver azureDevOpsAdditionalLinkResolver = new AzureDevOpsAdditionalLinkResolver(this.workItemRestClient, this.previousSpecItemIndex, this.connectorId, this.projects, this.includedWorkItemLinkRoles);
        return azureDevOpsAdditionalLinkResolver.withAdditionalUpdatedItems(lastScanTimestamp, issueUpdates);
    }

    @Override
    protected SpecItem createIssue(TeamscaleIssue preParsedIssue, TfsWorkItem tfsWorkItem, String type) {
        ResolvedRelations resolvedRelations = this.resolveRelations(tfsWorkItem);
        Map<String, List<String>> relations = resolvedRelations.relations();
        TeamscaleIssueTypeInfo typeInfo = this.resolveType(type);
        SpecItem specItem = new SpecItem(preParsedIssue, Collections.emptyList(), resolvedRelations.additionalParents(), new ArrayList<String>(relations.keySet()), new ArrayList<List<String>>(relations.values()), typeInfo.getType(), typeInfo.getTypeAbbreviation());
        if (this.isTestItem(typeInfo)) {
            return AzureDevOpsSpecItemSynchronizer.createTestItem(specItem);
        }
        return specItem;
    }

    @Override
    protected long determineBoundaryTimestamp(long lastScanTimestamp, long startTimestamp, boolean isNew) {
        return Math.max(lastScanTimestamp + 1L, startTimestamp);
    }

    private @NonNull TeamscaleIssueTypeInfo resolveType(String type) {
        if (type == null) {
            return new TeamscaleIssueTypeInfo(null, null);
        }
        String typeAbbreviation = this.itemTypeToTypeAbbreviation.get(type);
        if (typeAbbreviation == null) {
            typeAbbreviation = WorkItemUtils.generateWorkItemNameAbbreviation(type);
        }
        return new TeamscaleIssueTypeInfo(type, typeAbbreviation);
    }

    private @NonNull ResolvedRelations resolveRelations(TfsWorkItem tfsWorkItem) {
        LinkedHashMap<String, List<String>> foundRelations = new LinkedHashMap<String, List<String>>();
        List<String> additionalParents = Collections.emptyList();
        for (Pair includedWorkItemType : this.includedWorkItemLinkRoles) {
            String internalName = (String)includedWorkItemType.getSecond();
            List relations = tfsWorkItem.getRelationsForType(internalName);
            if ("System.LinkTypes.Hierarchy-Reverse".equals(internalName)) {
                if (relations.size() <= 1) continue;
                additionalParents = relations.subList(1, relations.size() - 1);
                continue;
            }
            String visibleName = ((String)includedWorkItemType.getFirst()).toLowerCase();
            foundRelations.put(visibleName, relations);
        }
        return new ResolvedRelations(additionalParents, foundRelations);
    }

    private static @NonNull ManualTestCase createTestItem(SpecItem specItem) {
        String rawTestSteps = specItem.getAdditionalFieldValue(TEST_STEP_CUSTOM_FIELD_NAME);
        List<ManualTestCase.TestStep> testSteps = AzureDevOpsTestStepsParser.parseTestSteps(rawTestSteps);
        ManualTestCase testItem = new ManualTestCase(specItem, testSteps);
        testItem.setCustomField(TEST_STEP_CUSTOM_FIELD_NAME, "");
        return testItem;
    }

    private boolean isTestItem(TeamscaleIssueTypeInfo type) {
        return this.itemTypesRepresentingTestCases.contains(type.getType()) || this.itemTypesRepresentingTestCases.contains(type.getTypeAbbreviation());
    }

    @Override
    protected boolean shouldFetchRelations() {
        return !this.includedWorkItemLinkRoles.isEmpty();
    }

    @Override
    protected Set<String> getItemTypes() {
        return new HashSet<String>((Collection<String>)this.itemTypes.getFirstList());
    }

    private void buildWorkItemTypeToAbbreviationMap() {
        for (Pair workItem : this.itemTypes) {
            this.itemTypeToTypeAbbreviation.put((String)workItem.getFirst(), (String)workItem.getSecond());
        }
    }

    private record ResolvedRelations(List<String> additionalParents, Map<String, List<String>> relations) {
    }
}

