/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis.finding;

import com.teamscale.core.analysis.configuration.model.option.NumericThresholds;
import com.teamscale.index.simulink.analysis.SimulinkFindingAnalysis;
import com.teamscale.index.simulink.analysis.finding.ThresholdFindingAnalysisBase;
import eu.cqse.check.framework.core.EFindingEnablement;
import java.util.Collection;
import java.util.Collections;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@SimulinkFindingAnalysis(name="Maximum blocks in subsystem", description="Creates a finding if any subsystem in the model has more direct sub-blocks than the defined threshold.", group="Maximum Blocks in Subsystem", qualityIndicator="Structure", enablement=EFindingEnablement.AUTO)
public class MaximumBlocksInSubsystemFinding
extends ThresholdFindingAnalysisBase {
    private static final String MESSAGE = "Violation of maximum number of blocks in subsystem ";

    @Override
    protected void analyzeModel(SimulinkModel model) {
        long maxBlocksInSubsytem = MaximumBlocksInSubsystemFinding.countIgnoringCommentedBlocks((Collection<SimulinkBlock>)model.getSubBlocks());
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("SubSystem"), (boolean)false, (boolean)false)) {
            maxBlocksInSubsytem = Math.max(maxBlocksInSubsytem, MaximumBlocksInSubsystemFinding.countIgnoringCommentedBlocks((Collection<SimulinkBlock>)block.getSubBlocks()));
        }
        NumericThresholds thresholds = this.getThresholds();
        if (maxBlocksInSubsytem > (long)thresholds.getRedThreshold()) {
            this.createAndReportFindingForBlock((SimulinkBlock)model, "Violation of maximum number of blocks in subsystem : " + maxBlocksInSubsytem, ETrafficLightColor.RED, Double.valueOf(maxBlocksInSubsytem));
        } else if (maxBlocksInSubsytem > (long)thresholds.getYellowThreshold()) {
            this.createAndReportFindingForBlock((SimulinkBlock)model, "Violation of maximum number of blocks in subsystem : " + maxBlocksInSubsytem, ETrafficLightColor.YELLOW, Double.valueOf(maxBlocksInSubsytem));
        }
    }

    public static long countIgnoringCommentedBlocks(Collection<SimulinkBlock> blocks) {
        return blocks.stream().filter(block -> !SimulinkUtils.isCommentedBlock((SimulinkBlock)block)).count();
    }
}

