/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis.metric;

import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysis;
import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysisBase;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

@SimulinkMetricAnalysis(name="S-Functions", description="Counts the number of S-functions in a model.", internalName="#s-functions", metricProperties={}, qualityIndicator="Structure")
public class SFunctionCountMetric
extends SimulinkMetricAnalysisBase {
    @Override
    public Double calculateMetricValue(SimulinkModel model) {
        int sfunctions = 0;
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!block.isOfType("S-Function") || block.getParent() instanceof StateflowBlock) continue;
            ++sfunctions;
        }
        return sfunctions;
    }
}

