/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.stacktrace.visitor;

import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.stacktrace.component.ExceptionRepresentation;
import com.teamscale.index.stacktrace.component.StackFrame;
import com.teamscale.index.stacktrace.component.Stacktrace;
import com.teamscale.index.stacktrace.resolver.UniformPathResolver;
import com.teamscale.index.stacktrace.visitor.IStacktraceVisitor;

public class UniformPathStacktraceVisitor
implements IStacktraceVisitor {
    private final UniformPathResolver uniformPathResolver;

    public UniformPathStacktraceVisitor(PathLookupIndex pathLookupIndex) {
        this.uniformPathResolver = new UniformPathResolver(pathLookupIndex);
    }

    @Override
    public void visit(Stacktrace stacktrace) {
        this.visit(stacktrace.getInitialException());
        for (ExceptionRepresentation causeException : stacktrace.getCauseExceptions()) {
            this.visit(causeException);
        }
    }

    @Override
    public void visit(StackFrame stackFrame) {
        this.uniformPathResolver.resolveFileName(stackFrame).ifPresent(uniformPath -> stackFrame.setUniformPath(uniformPath.toString()));
    }

    @Override
    public void visit(ExceptionRepresentation exceptionRepresentation) {
        for (StackFrame stackFrame : exceptionRepresentation.getStackFrames()) {
            this.visit(stackFrame);
        }
    }
}

