/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.system_info;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.system_info.ESystemHealthCheck;
import com.teamscale.index.system_info.SystemInfoEntry;
import com.teamscale.index.system_info.SystemInfoFragmentBase;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class SystemHealthFragment
extends SystemInfoFragmentBase {
    private static final long serialVersionUID = 1L;
    private final List<SystemInfoEntry> systemInfoEntries = new ArrayList<SystemInfoEntry>();

    public SystemHealthFragment(long updateIntervalMillis, IndexLayer indexLayer) throws StorageException {
        super(updateIntervalMillis);
        for (ESystemHealthCheck systemHealthCheck : ESystemHealthCheck.values()) {
            ESystemHealthCheck.CheckResult status = systemHealthCheck.performCheck(indexLayer);
            this.systemInfoEntries.add(SystemHealthFragment.createSystemInfoEntry(systemHealthCheck, status));
        }
    }

    private static SystemInfoEntry createSystemInfoEntry(ESystemHealthCheck systemHealthCheck, ESystemHealthCheck.CheckResult checkResult) {
        return SystemInfoEntry.ofMarkdown(systemHealthCheck.getReadableName(), checkResult.status().getReadableName() + " (" + checkResult.message() + ")");
    }

    @Override
    public String getFragmentCaption() {
        return "System Health";
    }

    @Override
    public int getFragmentOrder() {
        return 0;
    }

    @Override
    public List<SystemInfoEntry> convertToKeyValuePairs() {
        return this.systemInfoEntries;
    }
}

