/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import java.util.EnumSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="tasks.mail.notifications", name="Task Notification Settings", type=EOptionType.USER, hidden=true, category=EOptionCategory.OTHER)
@IndexValueClass(containedInBackup=true)
public class TaskNotificationOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "tasks.mail.notifications";
    public static final String OPTION_NAME = "Task Notification Settings";
    @JsonProperty(value="notifyOnTaskCreation")
    @OptionFieldDescription(name="Send me an email, if a task was created with me as assignee.")
    public boolean notifyOnTaskCreation = false;
    @JsonProperty(value="notifyOnTaskChange")
    @OptionFieldDescription(name="Send me an email, if a task has changed and I am either assignee or author.")
    public boolean notifyOnTaskChange = false;
    @JsonProperty(value="notifyOnCommentAdd")
    @OptionFieldDescription(name="Send me an email, if a comment was added to a task, where I am either assignee or author.")
    public boolean notifyOnCommentAdd = false;

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        return null;
    }

    public EnumSet<ETaskNotificationEvent> getTaskNotificationEvents() {
        EnumSet<ETaskNotificationEvent> result = EnumSet.noneOf(ETaskNotificationEvent.class);
        if (this.notifyOnTaskCreation) {
            result.add(ETaskNotificationEvent.TASK_CREATE);
        }
        if (this.notifyOnTaskChange) {
            result.add(ETaskNotificationEvent.TASK_CHANGE);
        }
        if (this.notifyOnCommentAdd) {
            result.add(ETaskNotificationEvent.COMMENT_ADD);
        }
        return result;
    }

    public static enum ETaskNotificationEvent {
        TASK_CREATE("created", "Created by "),
        TASK_CHANGE("updated", "Updated by "),
        COMMENT_ADD("commented on", "Comment from ");

        @JsonProperty(value="subjectTextSnippet")
        private final String subjectTextSnippet;
        @JsonProperty(value="bodyTextSnippet")
        private final String bodyTextSnippet;

        private ETaskNotificationEvent(String subjectTextSnippet, String bodyTextSnippet) {
            this.subjectTextSnippet = subjectTextSnippet;
            this.bodyTextSnippet = bodyTextSnippet;
        }

        public String getSubjectTextSnippet() {
            return this.subjectTextSnippet;
        }

        public String getBodyTextSnippet() {
            return this.bodyTextSnippet;
        }
    }
}

