/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.assessment;

import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessment;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;

public class TgaAssessor {
    private final long baselineTimestamp;
    private final ETgaAssessmentType assessmentType;

    public TgaAssessor(long baselineTimestamp, ETgaAssessmentType assessmentType) {
        this.baselineTimestamp = baselineTimestamp;
        this.assessmentType = assessmentType;
    }

    public AssessedTgaData assess(UnassessedTestGapData unassessedData) {
        List assessedMethods = CollectionUtils.map(unassessedData.getMethods(), this::assessMethod);
        return new AssessedTgaData(assessedMethods);
    }

    private AssessedTgaData.AssessedMethodData assessMethod(UnassessedTestGapData.UnassessedMethodData unassessedData) {
        ETgaAssessment assessment = this.calculateAssessment(unassessedData);
        ETestGapState state = assessment.getStateForAssessmentType(this.assessmentType);
        return new AssessedTgaData.AssessedMethodData(unassessedData.getLocation(), assessment, state, unassessedData.getMethodName(), unassessedData.getLastChangeTimestamp(), unassessedData.getLastChangedInIssueId(), unassessedData.getLastTestTimestamp());
    }

    private ETgaAssessment calculateAssessment(UnassessedTestGapData.UnassessedMethodData unassessedData) {
        if (this.isUnchanged(unassessedData)) {
            if (unassessedData.getLastTestTimestamp() >= this.baselineTimestamp || unassessedData.isExecutedByCrossAnnotation()) {
                return ETgaAssessment.UNCHANGED_EXECUTED;
            }
            return ETgaAssessment.UNCHANGED_NOT_EXECUTED;
        }
        if (this.isNew(unassessedData)) {
            if (TgaAssessor.isTestedAfterLastChange(unassessedData)) {
                return ETgaAssessment.ADDITION_TESTED_AFTER_LAST_CHANGE;
            }
            if (this.wasEverExecutedInTimeframe(unassessedData)) {
                return ETgaAssessment.ADDITION_EXECUTED_BEFORE_LAST_CHANGE;
            }
            return ETgaAssessment.ADDITION_NEVER_EXECUTED;
        }
        if (TgaAssessor.isTestedAfterLastChange(unassessedData)) {
            return ETgaAssessment.MODIFICATION_TESTED_AFTER_LAST_CHANGE;
        }
        if (this.wasEverExecutedInTimeframe(unassessedData)) {
            return ETgaAssessment.MODIFICATION_EXECUTED_BEFORE_LAST_CHANGE;
        }
        return ETgaAssessment.MODIFICATION_NEVER_EXECUTED;
    }

    private boolean wasEverExecutedInTimeframe(UnassessedTestGapData.UnassessedMethodData unassessedData) {
        return unassessedData.getLastTestTimestamp() > this.baselineTimestamp;
    }

    private static boolean isTestedAfterLastChange(UnassessedTestGapData.UnassessedMethodData unassessedData) {
        return unassessedData.getLastTestTimestamp() >= unassessedData.getLastChangeTimestamp() || unassessedData.isExecutedByCrossAnnotation();
    }

    private boolean isNew(UnassessedTestGapData.UnassessedMethodData unassessedData) {
        return unassessedData.getCreationTimestamp() > this.baselineTimestamp;
    }

    private boolean isUnchanged(UnassessedTestGapData.UnassessedMethodData unassessedData) {
        return unassessedData.getLastChangeTimestamp() <= this.baselineTimestamp;
    }
}

