/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.dotnet;

import com.teamscale.index.testgap.MethodMappingAnalysisUtils;
import com.teamscale.index.testgap.SourceLocation;
import com.teamscale.index.testgap.dotnet.DotNetMethodMappingIndex;
import java.io.File;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class MethodMappingUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void extractAndStoreMethodMappings(PairList<String, File> symbolFiles, DotNetMethodMappingIndex mappingIndex) throws StorageException {
        for (Pair symbolFile : symbolFiles) {
            MethodMappingAnalysisUtils.MethodMappingContainer mappingContainer;
            block3: {
                String expectedAssemblyName = FileSystemUtils.getFilenameWithoutExtension((String)((String)symbolFile.getFirst()));
                mappingContainer = null;
                try {
                    mappingContainer = MethodMappingAnalysisUtils.analyzeSymbolFile(((File)symbolFile.getSecond()).getAbsolutePath(), expectedAssemblyName);
                    if (expectedAssemblyName.equals(mappingContainer.getAssemblyName())) break block3;
                    LOGGER.warn("The expected assembly name \"" + expectedAssemblyName + "\" is not equal to the actual assembly name generated by the debug-info parser \"" + mappingContainer.getAssemblyName() + "\".");
                    mappingIndex.clearAssemblyInfo(expectedAssemblyName);
                }
                catch (ConQATException e) {
                    LOGGER.error("Unable to analyze symbol file " + ((File)symbolFile.getSecond()).getAbsolutePath() + ". This file will be ignored. All coverage for code covered by this file will be lost. Continuing with next symbol file.", (Throwable)e);
                    if (mappingContainer != null) break block3;
                    mappingIndex.clearAssemblyInfo(expectedAssemblyName);
                    continue;
                }
            }
            mappingIndex.replaceMappings(mappingContainer.getAssemblyName(), MethodMappingUtils.extractMappings(mappingContainer));
        }
    }

    private static PairList<String, SourceLocation> extractMappings(MethodMappingAnalysisUtils.MethodMappingContainer mappingContainer) {
        PairList mappings = new PairList();
        for (MethodMappingAnalysisUtils.MethodMapping mapping : CollectionUtils.filter(mappingContainer.getMethodMappings(), MethodMappingUtils::hasSourceAndIsNotCompilerHidden)) {
            Optional<String> uniformPath = mapping.getSourceFile();
            if (!uniformPath.isPresent()) continue;
            SourceLocation location = new SourceLocation(mapping.getRegion(), uniformPath.get());
            mappings.add((Object)mapping.getMethodToken(), (Object)location);
        }
        return mappings;
    }

    private static boolean hasSourceAndIsNotCompilerHidden(MethodMappingAnalysisUtils.MethodMapping mapping) {
        return mapping.getSourceFile().isPresent() && mapping.getRegion().getStart() != 0xFEEFEE;
    }

    private MethodMappingUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

