/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.merge_request.BranchPointNotFoundException;
import com.teamscale.index.merge_request.MergeBaseCacheIndex;
import com.teamscale.index.merge_request.MergeRequestDeltaIndex;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.MergeBaseResolver;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.FileListDataRetriever;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.query.ITgaCoverageSourceParameter;
import com.teamscale.index.testgap.query.TgaRequestBase;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

public class TgaBranchMergeRequest
extends TgaRequestBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<UniformPath> uniformPaths;
    private final Map<UniformPath, UniformPath> sourceToArchitecturePathMap;
    private final List<CommitDescriptor> codeCommitsOfSourceBranch;
    private final CommitDescriptor mergeBase;

    private TgaBranchMergeRequest(List<UniformPath> uniformPaths, long baseline, CommitDescriptor mergeTargetCommit, ITgaCoverageSourceParameter coverageParameters, ETgaAssessmentType assessmentType, IProjectId projectId, IndexLayer indexLayer, Map<UniformPath, UniformPath> sourceToArchitecturePathMap, List<CommitDescriptor> codeCommitsOfSourceBranch, CommitDescriptor mergeBase) {
        super(coverageParameters, assessmentType, baseline, mergeTargetCommit, projectId, indexLayer);
        this.uniformPaths = uniformPaths;
        this.sourceToArchitecturePathMap = sourceToArchitecturePathMap;
        this.codeCommitsOfSourceBranch = codeCommitsOfSourceBranch;
        this.mergeBase = mergeBase;
    }

    @Override
    protected ITgaDataRetriever createDataRetriever(TgaDataRetrieverIndexes dataRetrieverIndexes, CrossAnnotator crossAnnotator, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem(this.projectId);
        MethodInfoIndex mergeBaseMethodInfoIndex = null;
        if (this.mergeBase != null) {
            mergeBaseMethodInfoIndex = (MethodInfoIndex)projectStorageSystem.openProjectIndex(MethodInfoIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)this.mergeBase));
        }
        return new FileListDataRetriever(this.uniformPaths, this.getPartitions(), new TgaDataRetrieverIndexes(dataRetrieverIndexes, mergeBaseMethodInfoIndex), crossAnnotator, this.sourceToArchitecturePathMap, this.codeCommitsOfSourceBranch, this.testInfoFilter, tgaEnablementPerCodeScope);
    }

    public static TgaBranchMergeRequest createRequest(ITgaCoverageSourceParameter coverageParameters, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, TgaRequestQueryOptions tgaRequestParameters, ETgaAssessmentType assessmentType, IndexLayer indexLayer, IProjectId projectId) throws StorageException, BranchPointNotFoundException {
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem(projectId);
        CommitDescriptor sourceBranchCommit = timeIntervalParameters.resolveBaselineCommit((IFactory<ProjectStorageSystem, StorageException>)((IFactory)() -> projectStorageSystem));
        CommitDescriptor targetBranchCommit = timeIntervalParameters.resolveEndCommit((IFactory<ProjectStorageSystem, StorageException>)((IFactory)() -> projectStorageSystem));
        MergeBaseInfo mergeBase = TgaBranchMergeRequest.getMergeBaseInfo(tgaRequestParameters, sourceBranchCommit, targetBranchCommit, projectStorageSystem);
        return TgaBranchMergeRequest.createRequest(coverageParameters, assessmentType, sourceBranchCommit, tgaRequestParameters, mergeBase, indexLayer, projectId);
    }

    public static TgaBranchMergeRequest createRequest(ITgaCoverageSourceParameter coverageParameters, ETgaAssessmentType assessmentType, CommitDescriptor sourceBranchCommit, TgaRequestQueryOptions tgaRequestParameters, MergeBaseInfo mergeBase, IndexLayer indexLayer, IProjectId projectId) throws StorageException, BranchPointNotFoundException {
        CommitDescriptor branchPoint = TgaBranchMergeRequest.getBranchPoint(mergeBase);
        List<CommitDescriptor> codeCommitsOfSourceBranch = TgaBranchMergeRequest.determineRelevantSourceBranchCommits(mergeBase, indexLayer, projectId);
        Set<UniformPath> changedUniformPaths = TgaBranchMergeRequest.determineChangedUniformPaths(indexLayer, projectId, codeCommitsOfSourceBranch);
        UniformPath uniformPath = tgaRequestParameters.getUniformPath().orElseGet(UniformPath::codeRoot);
        Map<UniformPath, UniformPath> sourceToArchitecturePathMap = null;
        if (!uniformPath.isRoot()) {
            if (uniformPath.isArchitecturePath()) {
                MetricsToArchitectureMetricsMappingIndex mappingIndex = (MetricsToArchitectureMetricsMappingIndex)indexLayer.openProjectIndex(projectId, MetricsToArchitectureMetricsMappingIndex.class, HistoryAccessOption.readTimestamp((String)sourceBranchCommit.getBranchName(), (long)sourceBranchCommit.getTimestamp()));
                sourceToArchitecturePathMap = ArchitectureMetricsUtils.getRecursivePathMappings(mappingIndex, uniformPath);
                changedUniformPaths.retainAll(sourceToArchitecturePathMap.keySet());
            } else {
                changedUniformPaths.removeIf(path -> !path.hasAncestor(uniformPath));
            }
        }
        return new TgaBranchMergeRequest(CollectionUtils.sort(changedUniformPaths), branchPoint.getTimestamp(), sourceBranchCommit, coverageParameters, assessmentType, projectId, indexLayer, sourceToArchitecturePathMap, codeCommitsOfSourceBranch, mergeBase.getMergeBase());
    }

    private static CommitDescriptor getBranchPoint(MergeBaseInfo mergeBase) throws BranchPointNotFoundException {
        Optional<CommitDescriptor> branchPoint = mergeBase.getBranchPoint();
        if (branchPoint.isPresent()) {
            return branchPoint.get();
        }
        return (CommitDescriptor)mergeBase.getOldestNonMergeAncestorOfSource().orElseThrow(() -> new BranchPointNotFoundException(mergeBase));
    }

    private static @NonNull List<CommitDescriptor> determineRelevantSourceBranchCommits(MergeBaseInfo mergeBase, IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        List commitsWithoutMerges = CollectionUtils.filter(mergeBase.getAncestorsOfSource(), commit -> !commit.isMergeCommit());
        return TgaBranchMergeRequest.filterCodeCommits(commitsWithoutMerges, indexLayer, projectId);
    }

    private static MergeBaseInfo getMergeBaseInfo(TgaRequestQueryOptions tgaRequestParameters, CommitDescriptor sourceBranchCommit, CommitDescriptor targetBranchCommit, CommitResolvingStorageSystem projectStorageSystem) throws StorageException {
        MergeRequestDeltaIndex mergeRequestDeltaIndex;
        Optional<MergeRequestDeltaIndex.MergeRequestDelta> mergeRequestDelta;
        MergeRequestIdentifier mergeRequestIdentifier = tgaRequestParameters.getMergeRequestIdentifier();
        if (mergeRequestIdentifier != null && (mergeRequestDelta = (mergeRequestDeltaIndex = (MergeRequestDeltaIndex)projectStorageSystem.openProjectIndex(MergeRequestDeltaIndex.class, null)).getDelta(mergeRequestIdentifier)).isPresent()) {
            return mergeRequestDelta.get().mergeBase();
        }
        try {
            return TgaBranchMergeRequest.determineMergeBase(tgaRequestParameters.getMergeBaseCacheKey(), sourceBranchCommit, targetBranchCommit, projectStorageSystem);
        }
        catch (CommitResolutionException e) {
            if (e.commit.isHeadCommit()) {
                throw new StorageException("Could not find any commits on branch " + e.commit.getBranchName() + "!", (Throwable)e);
            }
            throw new StorageException((Throwable)e);
        }
    }

    private static MergeBaseInfo determineMergeBase(String mergeBaseCacheKey, CommitDescriptor sourceBranchCommit, CommitDescriptor targetBranchCommit, CommitResolvingStorageSystem projectStorageSystem) throws StorageException, CommitResolutionException {
        MergeBaseCacheIndex mergeBaseCacheIndex;
        Optional<MergeBaseInfo> mergeBase;
        if (mergeBaseCacheKey != null && (mergeBase = (mergeBaseCacheIndex = (MergeBaseCacheIndex)projectStorageSystem.openProjectIndex(MergeBaseCacheIndex.class, null)).getValue(mergeBaseCacheKey)).isPresent()) {
            return mergeBase.get();
        }
        return MergeBaseResolver.computeMergeBaseInfo(sourceBranchCommit, targetBranchCommit, (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null)).orElseThrow(() -> new BadRequestException("Could not determine common merge base!"));
    }

    private static Set<UniformPath> determineChangedUniformPaths(IndexLayer indexLayer, IProjectId projectId, List<CommitDescriptor> codeCommitsOfSourceBranch) throws StorageException {
        HashSet<UniformPath> uniformPaths = new HashSet<UniformPath>();
        RepositoryLogFileIndex repositoryLogFileIndex = (RepositoryLogFileIndex)indexLayer.openProjectIndex(projectId, RepositoryLogFileIndex.class, null);
        List<RepositoryLogFileEntry> entries = repositoryLogFileIndex.getEntriesByCommits(codeCommitsOfSourceBranch);
        for (RepositoryLogFileEntry entry : entries) {
            if (entry.isDeleted()) continue;
            uniformPaths.add(entry.getUniformPath());
        }
        return uniformPaths;
    }

    private static List<CommitDescriptor> filterCodeCommits(List<ParentedCommitDescriptor> commits, IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        RepositoryLogIndex logIndex = (RepositoryLogIndex)indexLayer.openProjectIndex(projectId, RepositoryLogIndex.class, null);
        List logEntries = logIndex.getEntries(commits);
        ArrayList<CommitDescriptor> result = new ArrayList<CommitDescriptor>();
        for (int i = 0; i < commits.size(); ++i) {
            RepositoryLogEntryAggregate currentLogEntry = (RepositoryLogEntryAggregate)logEntries.get(i);
            ParentedCommitDescriptor commit = commits.get(i);
            if (currentLogEntry == null) {
                LOGGER.warn("No log entry found for commit " + String.valueOf(commit));
                continue;
            }
            Set<ECommitType> commitTypes = currentLogEntry.getCommitTypes();
            if (commitTypes == null) {
                LOGGER.warn("No commit types found for commit " + String.valueOf(commit));
                continue;
            }
            if (!commitTypes.contains((Object)ECommitType.CODE_COMMIT)) continue;
            result.add((CommitDescriptor)commit);
        }
        return result;
    }

    @Override
    protected String getTgaRequestPrefix() {
        return "Test gap data for merge request";
    }
}

