/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.query.TgaRequestAssessmentFormOptions;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;

public abstract sealed class TgaRequestAssessmentOptionsBase
permits TgaRequestAssessmentFormOptions, TgaRequestAssessmentQueryOptions {
    public static final String EXECUTION_ONLY_PARAMETER_NAME = "execution-only";
    public static final String CHURN_PARAMETER_NAME = "churn";
    protected static final String EXECUTION_ONLY_PARAMETER_DOC = "If this parameter is given, the service disregards code changes and only assesses execution/coverage of methods. The result will not contain information about test gaps, but only about which methods were executed.";
    protected static final String CHURN_PARAMETER_DOC = "Whether we want to view only the churn. This means coverage is ignored for the assessment and methods are only classified as unchanged, added or modified.";

    public abstract boolean isExecutionOnly();

    public abstract boolean isChurn();

    public ETgaAssessmentType getAssessmentType() {
        if (this.isExecutionOnly()) {
            return ETgaAssessmentType.EXECUTION_ONLY;
        }
        if (this.isChurn()) {
            return ETgaAssessmentType.CHURN;
        }
        return ETgaAssessmentType.TEST_GAP;
    }

    public String toString() {
        return this.getAssessmentType().name();
    }
}

